/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate;

import com.cyberway.mp.bc.dal.SqlCommand;
import com.cyberway.mp.bc.dal.annotation.LogicDelete;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.generate.AbstractSqlGenerator;
import com.cyberway.mp.bc.dal.generate.LogicDeleteGenerator;
import com.cyberway.mp.bc.dal.generate.QueryMergeParam;
import com.cyberway.mp.bc.dal.generate.parser.MethodNameParser;
import com.cyberway.mp.bc.dal.generate.parser.MethodParser;
import com.cyberway.mp.bc.dal.generate.parser.MethodParserResult;
import com.cyberway.mp.bc.dal.generate.parser.ParserResult;
import com.cyberway.mp.bc.dal.util.EntityUtils;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.mapping.SqlCommandType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class DeleteGenerator
extends AbstractSqlGenerator {
    private static final String DELETE = "delete";
    private static final String DELETE_BY_ID_IN = "deleteByIdIn";
    private final List<String> specMethods = new ArrayList<String>();
    @Autowired
    private MethodNameParser methodNameParser;
    @Autowired
    private MethodParser methodParser;
    @Autowired
    private LogicDeleteGenerator logicDeleteGenerator;

    public void setMethodNameParser(MethodNameParser methodNameParser) {
        this.methodNameParser = methodNameParser;
    }

    public void setMethodParser(MethodParser methodParser) {
        this.methodParser = methodParser;
    }

    public void setLogicDeleteGenerator(LogicDeleteGenerator logicDeleteGenerator) {
        this.logicDeleteGenerator = logicDeleteGenerator;
    }

    public DeleteGenerator() {
        this.specMethods.add(DELETE);
        this.specMethods.add(DELETE_BY_ID_IN);
    }

    @Override
    public boolean match(Method method) {
        String name = method.getName();
        return this.match(name);
    }

    @Override
    public boolean match(String methodName) {
        for (String specMethod : this.specMethods) {
            if (!methodName.equals(specMethod)) continue;
            return true;
        }
        return methodName.startsWith(DELETE);
    }

    @Override
    public SqlCommand generate(Method method, Class<?> mapper) {
        Class<?> entityClass = EntityUtils.getEntityClass(mapper);
        Table table = (Table)AnnotationUtils.getAnnotation(entityClass, Table.class);
        LogicDelete logicDelete = (LogicDelete)AnnotationUtils.getAnnotation(entityClass, LogicDelete.class);
        if (logicDelete != null) {
            return this.logicDeleteGenerator.logicDeleteGenerate(entityClass, table, logicDelete, method, mapper);
        }
        return this.physicsDelete(entityClass, table, method, mapper);
    }

    private SqlCommand physicsDelete(Class<?> entityClass, Table table, Method method, Class<?> mapper) {
        String name = method.getName();
        if (name.equals(DELETE)) {
            String sql = this.generateDeleteSql(entityClass.getSimpleName(), table);
            return this.createSqlCommand(sql, SqlCommandType.DELETE);
        }
        if (name.equals(DELETE_BY_ID_IN)) {
            String sql = this.generateDeleteInSql(entityClass.getSimpleName(), table);
            return this.createSqlCommand(sql, SqlCommandType.DELETE);
        }
        if (name.startsWith(DELETE)) {
            if (this.hasQueryBean(method, mapper)) {
                MethodParserResult result = this.methodParser.parse(method, mapper, false);
                return this.generateFromQueryBean(result, table, entityClass.getSimpleName());
            }
            String sql = this.generatePrefixDeleteSql(entityClass.getSimpleName(), name, table);
            return new SqlCommand(sql, SqlCommandType.DELETE);
        }
        return null;
    }

    private String generatePrefixDeleteSql(String entityName, String methodName, Table table) {
        String methodRemovePrefix = methodName.substring(DELETE.length());
        ParserResult parserResult = this.methodNameParser.parse(methodRemovePrefix);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("delete from ");
        stringBuilder.append(this.findTableName(null, entityName, table));
        stringBuilder.append(parserResult.getPredicate().toSqlFrame(parserResult.getPredicate().hasScript()));
        if (parserResult.getPredicate().hasScript()) {
            return String.format("<script>%s</script>", stringBuilder);
        }
        return stringBuilder.toString();
    }

    private String generateDeleteSql(String entityName, Table table) {
        String where = "ID = #{id}";
        SQL sql = new SQL();
        sql.DELETE_FROM(this.findTableName(null, entityName, table));
        sql.WHERE(where);
        return sql.toString();
    }

    private String generateDeleteInSql(String entityName, Table table) {
        return "<script> delete from " + this.findTableName(null, entityName, table) + " where id in <foreach item='id' index='index' collection='ids' open='(' separator=',' close=')'>#{id}</foreach></script>";
    }

    private SqlCommand generateFromQueryBean(MethodParserResult result, Table table, String entityName) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("delete from ");
        stringBuilder.append(this.findTableName(result.getPredicateAnno(), entityName, table));
        if (!result.sqlNeedMerge()) {
            stringBuilder.append(result.getPredicate().toSqlFrame(result.getPredicate().hasScript()));
            return new SqlCommand(stringBuilder.toString(), SqlCommandType.DELETE);
        }
        return new SqlCommand(stringBuilder.toString(), SqlCommandType.DELETE, true);
    }

    @Override
    public SqlCommand merge(Method method, Class<?> mapper, Object target, String sqlFrame) {
        Class<?> entityClass = EntityUtils.getEntityClass(mapper);
        LogicDelete logicDelete = (LogicDelete)AnnotationUtils.getAnnotation(entityClass, LogicDelete.class);
        if (logicDelete != null) {
            return this.logicDeleteGenerator.merge(method, mapper, target, sqlFrame);
        }
        QueryMergeParam queryMergeParam = new QueryMergeParam(target, sqlFrame, SqlCommandType.DELETE);
        return this.noneSearchQueryBeanMerge(queryMergeParam);
    }
}

