/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate;

import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.SqlCommand;
import com.cyberway.mp.bc.dal.annotation.LogicDelete;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.generate.AbstractSqlGenerator;
import com.cyberway.mp.bc.dal.generate.parser.Column;
import com.cyberway.mp.bc.dal.generate.parser.MethodNameParser;
import com.cyberway.mp.bc.dal.generate.parser.Pageable;
import com.cyberway.mp.bc.dal.generate.parser.ParserResult;
import com.cyberway.mp.bc.dal.util.EntityUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.mapping.SqlCommandType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class FindGenerator
extends AbstractSqlGenerator {
    private static final String PREFIX_FIND = "find";
    private static final String FIND_ALL = "findAll";
    private static final String FIND_ONE = "findOne";
    private static final String SCRIPT_END = "</script>";
    private final List<String> specMethods = new ArrayList<String>();
    @Autowired
    private MethodNameParser methodParser;

    public FindGenerator() {
        this.specMethods.add(FIND_ALL);
        this.specMethods.add(FIND_ONE);
    }

    @Override
    public boolean match(Method method) {
        String name = method.getName();
        for (String specMethod : this.specMethods) {
            if (!name.equals(specMethod)) continue;
            return true;
        }
        return name.startsWith(PREFIX_FIND);
    }

    @Override
    public boolean match(String methodName) {
        return methodName.startsWith(PREFIX_FIND);
    }

    @Override
    public SqlCommand merge(Method method, Class<?> mapper, Object target, String sqlFrame) {
        if (this.hasPageParam(method)) {
            PageParam pageParam = this.findPageParam(target);
            String pageParamName = this.findPageParamName(target);
            Pageable pageable = new Pageable(pageParam, this.dalProperties, pageParamName);
            if (this.needAddDefaultOrderBy(true, new String[]{sqlFrame})) {
                sqlFrame = (String)sqlFrame + " order by id ";
            }
            Object sql = ((String)sqlFrame).endsWith(SCRIPT_END) ? ((String)sqlFrame).replace(SCRIPT_END, pageable.toSqlFrame(pageable.hasScript()) + SCRIPT_END) : (String)sqlFrame + pageable.toSqlFrame(pageable.hasScript());
            return new SqlCommand((String)sql, SqlCommandType.SELECT);
        }
        return new SqlCommand((String)sqlFrame, SqlCommandType.SELECT);
    }

    @Override
    public SqlCommand generate(Method method, Class<?> mapper) {
        Class<?> entityClass = EntityUtils.getEntityClass(mapper);
        String name = method.getName();
        if (name.equals(FIND_ALL)) {
            String sql = this.generateFindAllSql(entityClass);
            return this.createSqlCommand(sql, SqlCommandType.SELECT);
        }
        if (name.equals(FIND_ONE)) {
            String sql = this.generateFindOneSql(entityClass);
            return this.createSqlCommand(sql, SqlCommandType.SELECT);
        }
        if (name.startsWith(PREFIX_FIND)) {
            String sql = this.generatePrefixFindSql(name, entityClass);
            if (this.hasPageParam(method)) {
                return new SqlCommand(sql, SqlCommandType.SELECT, true);
            }
            return this.createSqlCommand(sql, SqlCommandType.SELECT);
        }
        return null;
    }

    private String generateFindAllSql(Class<?> entityClass) {
        String entityName = entityClass.getSimpleName();
        SQL sql = new SQL();
        sql.SELECT("*");
        sql.FROM(this.findTableName(null, entityName, (Table)AnnotationUtils.getAnnotation(entityClass, Table.class)));
        return sql.toString();
    }

    private String generateFindOneSql(Class<?> entityClass) {
        String entityName = entityClass.getSimpleName();
        SQL sql = new SQL();
        StringBuilder stringBuilder = new StringBuilder();
        sql.SELECT("*");
        sql.FROM(this.findTableName(null, entityName, (Table)AnnotationUtils.getAnnotation(entityClass, Table.class)));
        stringBuilder.append(" id = #{id}");
        sql.WHERE(stringBuilder.toString());
        return sql.toString();
    }

    private String generatePrefixFindSql(String methodName, Class<?> entityClass) {
        String entityName = entityClass.getSimpleName();
        String methodRemovePrefix = methodName.substring(PREFIX_FIND.length());
        ParserResult parserResult = this.methodParser.parse(methodRemovePrefix);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("select ");
        if (parserResult.getColumns() == null) {
            stringBuilder.append("*");
        } else {
            if (parserResult.getColumns().isDistinct()) {
                stringBuilder.append(" distinct  ");
            }
            List<Column> columList = parserResult.getColumns().getColumns();
            stringBuilder.append(String.join((CharSequence)" , ", (CharSequence[])columList.stream().map(column -> Strings.underscoreName((String)column.getName())).toArray(String[]::new)));
        }
        stringBuilder.append(" from ");
        stringBuilder.append(this.findTableName(null, entityName, (Table)AnnotationUtils.getAnnotation(entityClass, Table.class)));
        stringBuilder.append(parserResult.getPredicate().toSqlFrame(parserResult.getPredicate().hasScript(), (LogicDelete)AnnotationUtils.getAnnotation(entityClass, LogicDelete.class)));
        if (parserResult.getPredicate().hasScript()) {
            return String.format("<script>%s</script>", stringBuilder);
        }
        return stringBuilder.toString();
    }

    private boolean hasPageParam(Method method) {
        Parameter[] params;
        for (Parameter param : params = method.getParameters()) {
            if (!param.getType().equals(PageParam.class)) continue;
            return true;
        }
        return false;
    }

    private PageParam findPageParam(Object myBaitsParams) {
        Map paramMap = (Map)myBaitsParams;
        for (Object value : paramMap.values()) {
            if (!(value instanceof PageParam)) continue;
            return (PageParam)value;
        }
        throw new IllegalArgumentException("find \u5206\u9875\u65b9\u6cd5\u627e\u4e0d\u5230\u5206\u9875\u53c2\u6570");
    }
}

