/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate;

import com.cyberway.mp.bc.dal.SqlCommand;
import com.cyberway.mp.bc.dal.annotation.LogicDelete;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.generate.AbstractSqlGenerator;
import com.cyberway.mp.bc.dal.generate.DeletedValue;
import com.cyberway.mp.bc.dal.generate.QueryMergeParam;
import com.cyberway.mp.bc.dal.generate.parser.MethodNameParser;
import com.cyberway.mp.bc.dal.generate.parser.MethodParser;
import com.cyberway.mp.bc.dal.generate.parser.MethodParserResult;
import com.cyberway.mp.bc.dal.generate.parser.ParserResult;
import java.lang.reflect.Method;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.mapping.SqlCommandType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class LogicDeleteGenerator
extends AbstractSqlGenerator {
    private static final String DELETE = "delete";
    private static final String SET = " set ";
    private static final String DELETE_BY_ID_IN = "deleteByIdIn";
    @Autowired
    private MethodNameParser methodNameParser;
    @Autowired
    private MethodParser methodParser;

    public void setMethodNameParser(MethodNameParser methodNameParser) {
        this.methodNameParser = methodNameParser;
    }

    public void setMethodParser(MethodParser methodParser) {
        this.methodParser = methodParser;
    }

    @Override
    public boolean match(Method method) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SqlCommand generate(Method method, Class<?> mapper) {
        throw new UnsupportedOperationException();
    }

    public SqlCommand logicDeleteGenerate(Class<?> entityClass, Table table, LogicDelete logicDelete, Method method, Class<?> mapper) {
        String name = method.getName();
        if (name.equals(DELETE)) {
            String sql = this.generateLogicDeleteSql(entityClass.getSimpleName(), table, logicDelete);
            return this.createSqlCommand(sql, SqlCommandType.UPDATE);
        }
        if (name.equals(DELETE_BY_ID_IN)) {
            String sql = this.generateLogicDeleteInSql(entityClass.getSimpleName(), table, logicDelete);
            return this.createSqlCommand(sql, SqlCommandType.UPDATE);
        }
        if (name.startsWith(DELETE)) {
            if (this.hasQueryBean(method, mapper)) {
                MethodParserResult result = this.methodParser.parse(method, mapper, false);
                return this.generateFromQueryBean(result, table, entityClass.getSimpleName(), logicDelete);
            }
            String sql = this.generatePrefixLogicDeleteSql(entityClass.getSimpleName(), name, table, logicDelete);
            return this.createSqlCommand(sql, SqlCommandType.UPDATE);
        }
        return null;
    }

    private String generatePrefixLogicDeleteSql(String entityName, String methodName, Table table, LogicDelete logicDelete) {
        String methodRemovePrefix = methodName.substring(DELETE.length());
        ParserResult parserResult = this.methodNameParser.parse(methodRemovePrefix);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("update ");
        stringBuilder.append(this.findTableName(null, entityName, table));
        stringBuilder.append(SET).append(logicDelete.fieldName()).append("=").append(DeletedValue.DELETED.getDeleteValue());
        stringBuilder.append(parserResult.getPredicate().toSqlFrame(parserResult.getPredicate().hasScript()));
        if (parserResult.getPredicate().hasScript()) {
            return String.format("<script>%s</script>", stringBuilder);
        }
        return stringBuilder.toString();
    }

    private String generateLogicDeleteSql(String entityName, Table table, LogicDelete logicDelete) {
        SQL sql = new SQL();
        String where = "ID = #{id}";
        sql.UPDATE(this.findTableName(null, entityName, table));
        sql.SET(logicDelete.fieldName() + "=" + DeletedValue.DELETED.getDeleteValue());
        sql.WHERE(where);
        return sql.toString();
    }

    private String generateLogicDeleteInSql(String entityName, Table table, LogicDelete logicDelete) {
        return "<script> update " + this.findTableName(null, entityName, table) + SET + logicDelete.fieldName() + "=" + DeletedValue.DELETED.getDeleteValue() + " where id in <foreach item='id' index='index' collection='ids' open='(' separator=',' close=')'>#{id}</foreach></script>";
    }

    private SqlCommand generateFromQueryBean(MethodParserResult result, Table table, String entityName, LogicDelete logicDelete) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("update ");
        stringBuilder.append(this.findTableName(result.getPredicateAnno(), entityName, table));
        stringBuilder.append(SET).append(logicDelete.fieldName()).append("=").append(DeletedValue.DELETED.getDeleteValue());
        if (!result.sqlNeedMerge()) {
            stringBuilder.append(result.getPredicate().toSqlFrame(result.getPredicate().hasScript()));
            return new SqlCommand(stringBuilder.toString(), SqlCommandType.UPDATE);
        }
        return new SqlCommand(stringBuilder.toString(), SqlCommandType.UPDATE, true);
    }

    @Override
    public SqlCommand merge(Method method, Class<?> mapper, Object target, String sqlFrame) {
        QueryMergeParam queryMergeParam = new QueryMergeParam(target, sqlFrame, SqlCommandType.UPDATE);
        return this.noneSearchQueryBeanMerge(queryMergeParam);
    }
}

