/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate;

import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.SqlCommand;
import com.cyberway.mp.bc.dal.annotation.Alias;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.annotation.query.IgnoreField;
import com.cyberway.mp.bc.dal.generate.AbstractSqlGenerator;
import com.cyberway.mp.bc.dal.generate.QueryMergeParam;
import com.cyberway.mp.bc.dal.generate.dialect.BatchGenerator;
import com.cyberway.mp.bc.dal.generate.dialect.BatchGeneratorFactory;
import com.cyberway.mp.bc.dal.generate.parser.Columns;
import com.cyberway.mp.bc.dal.generate.parser.MethodNameParser;
import com.cyberway.mp.bc.dal.generate.parser.MethodParser;
import com.cyberway.mp.bc.dal.generate.parser.MethodParserResult;
import com.cyberway.mp.bc.dal.generate.parser.ParserResult;
import com.cyberway.mp.bc.dal.util.EntityUtils;
import java.beans.Introspector;
import java.lang.invoke.CallSite;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.ibatis.jdbc.SQL;
import org.apache.ibatis.mapping.SqlCommandType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class ModifyGenerator
extends AbstractSqlGenerator {
    public static final String SAVE = "save";
    public static final String UPDATE_BY_ID = "updateById";
    public static final String UPDATE_BY_ID_WITH_NULL_VALUE = "updateByIdWithNullValue";
    private static final String PREFIX_UPDATE = "update";
    public static final String UPDATE_BY = "updateBy";
    private static final String SET = " set ";
    public static final String BATCH_INSERT = "batchInsert";
    public static final String BATCH_UPDATE = "batchUpdate";
    private static final String BATCH_INSERT_PARAMS = "entities";
    private final List<String> specMethods = new ArrayList<String>();
    @Autowired
    private MethodNameParser methodNameParser;
    @Autowired
    private MethodParser methodParser;
    @Autowired
    private BatchGeneratorFactory batchGeneratorFactory;

    public void setMethodNameParser(MethodNameParser methodParser) {
        this.methodNameParser = methodParser;
    }

    public void setMethodParser(MethodParser methodParser) {
        this.methodParser = methodParser;
    }

    public void setBatchGeneratorFactory(BatchGeneratorFactory batchGeneratorFactory) {
        this.batchGeneratorFactory = batchGeneratorFactory;
    }

    public ModifyGenerator() {
        this.specMethods.add(SAVE);
        this.specMethods.add(UPDATE_BY_ID);
        this.specMethods.add(UPDATE_BY_ID_WITH_NULL_VALUE);
        this.specMethods.add(BATCH_INSERT);
        this.specMethods.add(BATCH_UPDATE);
    }

    @Override
    public boolean match(Method method) {
        String name = method.getName();
        return this.match(name);
    }

    @Override
    public boolean match(String methodName) {
        for (String specMethod : this.specMethods) {
            if (!methodName.equals(specMethod)) continue;
            return true;
        }
        return methodName.startsWith(PREFIX_UPDATE);
    }

    @Override
    public SqlCommand generate(Method method, Class<?> mapper) {
        String name = method.getName();
        if (name.equals(SAVE)) {
            return new SqlCommand("", SqlCommandType.INSERT, true);
        }
        if (name.equals(UPDATE_BY_ID)) {
            return new SqlCommand("", SqlCommandType.UPDATE, true);
        }
        if (name.equals(UPDATE_BY_ID_WITH_NULL_VALUE)) {
            return new SqlCommand("", SqlCommandType.UPDATE, true);
        }
        if (name.equals(BATCH_INSERT)) {
            return new SqlCommand("", SqlCommandType.INSERT, true);
        }
        if (name.equals(BATCH_UPDATE)) {
            return new SqlCommand("", SqlCommandType.UPDATE, true);
        }
        if (name.startsWith(PREFIX_UPDATE)) {
            Class<?> entityClass = EntityUtils.getEntityClass(mapper);
            Table table = (Table)AnnotationUtils.getAnnotation(entityClass, Table.class);
            if (this.hasQueryBean(method, mapper)) {
                MethodParserResult result = this.methodParser.parse(method, mapper, false);
                return this.generateFromQueryBean(result, table, entityClass.getSimpleName());
            }
            return this.generatePrefixUpdate(table, entityClass.getSimpleName(), name);
        }
        return null;
    }

    private SqlCommand generatePrefixUpdate(Table table, String entityName, String name) {
        String methodRemovePrefix = name.substring(PREFIX_UPDATE.length());
        ParserResult parserResult = this.methodNameParser.parse(methodRemovePrefix);
        boolean isNeedInterceptGenerate = true;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(" update ");
        stringBuilder.append(this.findTableName(null, entityName, table));
        stringBuilder.append(SET);
        if (parserResult.getColumns() != null) {
            isNeedInterceptGenerate = false;
            stringBuilder.append(this.updateField(parserResult.getColumns()));
        }
        stringBuilder.append(parserResult.getPredicate().toSqlFrame(parserResult.getPredicate().hasScript()));
        String sql = stringBuilder.toString();
        if (parserResult.getPredicate().hasScript()) {
            sql = String.format("<script>%s</script>", stringBuilder);
        }
        return new SqlCommand(sql, SqlCommandType.UPDATE, isNeedInterceptGenerate);
    }

    private String updateField(Columns columns) {
        return String.join((CharSequence)" , ", (CharSequence[])columns.getColumns().stream().map(column -> this.sqlEscape.escapeColName(Strings.underscoreName((String)column.getName())) + " = #{" + Introspector.decapitalize(column.getName()) + "}").toArray(String[]::new));
    }

    @Override
    public SqlCommand merge(Method method, Class<?> mapper, Object myBaitsParams, String sqlFrame) {
        String methodName = method.getName();
        if (methodName.equals(SAVE)) {
            String sql = this.generateSaveSql(myBaitsParams);
            return new SqlCommand(sql, SqlCommandType.INSERT);
        }
        if (methodName.equals(BATCH_INSERT)) {
            String sql = this.generateBatchSaveSql(myBaitsParams);
            return new SqlCommand(sql, SqlCommandType.INSERT);
        }
        if (methodName.equals(BATCH_UPDATE)) {
            String sql = this.generateBatchUpdateSql(myBaitsParams);
            return new SqlCommand(sql, SqlCommandType.UPDATE);
        }
        if (methodName.equals(UPDATE_BY_ID)) {
            String sql = this.generateUpdateBySql(myBaitsParams, true);
            return new SqlCommand(sql, SqlCommandType.UPDATE);
        }
        if (methodName.equals(UPDATE_BY_ID_WITH_NULL_VALUE)) {
            String sql = this.generateUpdateBySql(myBaitsParams, false);
            return new SqlCommand(sql, SqlCommandType.UPDATE);
        }
        if (methodName.startsWith(PREFIX_UPDATE)) {
            String sql = "";
            if (this.isUpdateAllEntity(method)) {
                String entityParamName = method.getParameters()[0].getName();
                sql = this.mergeUpdateSql(myBaitsParams, sqlFrame, entityParamName, true);
                if (this.hasQueryBean(method, mapper)) {
                    QueryMergeParam queryMergeParam = new QueryMergeParam(myBaitsParams, sql, SqlCommandType.UPDATE);
                    return this.noneSearchQueryBeanMerge(queryMergeParam);
                }
            } else {
                sql = sqlFrame;
            }
            return new SqlCommand(sql, SqlCommandType.UPDATE);
        }
        return null;
    }

    private boolean isUpdateAllEntity(Method method) {
        String name = method.getName();
        String methodRemovePrefix = name.substring(PREFIX_UPDATE.length());
        ParserResult parserResult = this.methodNameParser.parse(methodRemovePrefix);
        return parserResult.getColumns() == null;
    }

    private String mergeUpdateSql(Object myBaitsParams, String sqlFrame, String entityParamName, boolean ignoreNullValueField) {
        StringBuilder stringBuilder = new StringBuilder();
        String[] split = StringUtils.splitByWholeSeparator((String)sqlFrame, (String)SET, (int)2);
        stringBuilder.append(split[0]);
        stringBuilder.append(SET);
        stringBuilder.append(String.join((CharSequence)",", this.findUpdateFields(myBaitsParams, entityParamName, ignoreNullValueField)));
        stringBuilder.append(split[1]);
        return stringBuilder.toString();
    }

    private String generateSaveSql(Object myBaitsParams) {
        List<Field> fields = super.getEntityNotStaticAndNotNullFields(myBaitsParams);
        ArrayList<String> insertField = new ArrayList<String>();
        ArrayList<CallSite> insertFieldParam = new ArrayList<CallSite>();
        for (Field field : fields) {
            IgnoreField ignoreField = field.getAnnotation(IgnoreField.class);
            if (ignoreField != null) continue;
            insertField.add(this.getDBFieldName(field));
            insertFieldParam.add((CallSite)((Object)("#{" + field.getName() + "}")));
        }
        Class<?> entityClass = myBaitsParams.getClass();
        Table table = (Table)AnnotationUtils.getAnnotation(entityClass, Table.class);
        SQL sql = new SQL();
        sql.INSERT_INTO(this.findTableName(null, entityClass.getSimpleName(), table));
        sql.INTO_COLUMNS(insertField.toArray(new String[0]));
        sql.INTO_VALUES(insertFieldParam.toArray(new String[0]));
        return sql.toString();
    }

    private String findModifyTable(Object modifyEntity) {
        Class<?> entityClass = modifyEntity.getClass();
        Table table = (Table)AnnotationUtils.getAnnotation(entityClass, Table.class);
        return this.findTableName(null, entityClass.getSimpleName(), table);
    }

    private Pair<List<String>, List<String>> findFieldAndParam(Collection<?> entities, boolean isUpdate) {
        HashSet<Field> result = new HashSet<Field>();
        for (Object entity : entities) {
            List<Field> fields = super.getEntityNotStaticAndNotNullFields(entity);
            fields = fields.stream().filter(field -> null == field.getAnnotation(IgnoreField.class)).filter(field -> {
                if (isUpdate) {
                    return !this.isIgnoreUpdateField(entity.getClass().getName(), (Field)field);
                }
                return true;
            }).collect(Collectors.toList());
            result.addAll(fields);
        }
        ArrayList<String> resultField = new ArrayList<String>();
        ArrayList<CallSite> resultFieldParam = new ArrayList<CallSite>();
        for (Field field2 : result) {
            resultField.add(this.getDBFieldName(field2));
            resultFieldParam.add((CallSite)((Object)("#{item." + field2.getName() + "}")));
        }
        return Pair.of(resultField, resultFieldParam);
    }

    private String generateBatchSaveSql(Object myBaitsParams) {
        return this.generateBatchSql(myBaitsParams, false);
    }

    private String generateBatchSql(Object myBaitsParams, boolean isUpdate) {
        if (!(myBaitsParams instanceof Map) && ((Map)myBaitsParams).get(BATCH_INSERT_PARAMS) == null) {
            throw new IllegalArgumentException(" batchInsert or batchUpdate arg error");
        }
        Collection entities = (Collection)((Map)myBaitsParams).get(BATCH_INSERT_PARAMS);
        if (entities.isEmpty()) {
            throw new IllegalArgumentException(" batchInsert or batchUpdate arg lists must not empty");
        }
        Object firstEntity = entities.iterator().next();
        Pair<List<String>, List<String>> fieldAndParam = this.findFieldAndParam(entities, isUpdate);
        String tableName = this.findModifyTable(firstEntity);
        BatchGenerator batchGenerator = this.batchGeneratorFactory.getBatchGenerator(this.dalProperties.currentDialect());
        if (isUpdate) {
            return batchGenerator.batchUpdate(tableName, (List)fieldAndParam.getLeft(), (List)fieldAndParam.getRight()).toString();
        }
        return batchGenerator.batchInsert(tableName, (List)fieldAndParam.getLeft(), (List)fieldAndParam.getRight()).toString();
    }

    private String generateBatchUpdateSql(Object myBaitsParams) {
        return this.generateBatchSql(myBaitsParams, true);
    }

    private String getDBFieldName(Field field) {
        Alias alias = (Alias)AnnotationUtils.getAnnotation((AnnotatedElement)field, Alias.class);
        if (alias != null && StringUtils.isNotBlank((CharSequence)alias.name())) {
            return this.sqlEscape.escapeColName(alias.name());
        }
        return this.sqlEscape.escapeColName(Strings.underscoreName((String)field.getName()));
    }

    private String generateUpdateBySql(Object myBaitsParams, boolean ignoreNullValueField) {
        Class<?> entityClass = this.findEntity(myBaitsParams).getClass();
        Table table = (Table)AnnotationUtils.getAnnotation(entityClass, Table.class);
        String stringBuilder = "id = #{id}";
        SQL sql = new SQL();
        sql.UPDATE(this.findTableName(null, entityClass.getSimpleName(), table));
        sql.SET(this.findUpdateFields(myBaitsParams, "t", ignoreNullValueField));
        sql.WHERE(stringBuilder);
        return sql.toString();
    }

    private Object findEntity(Object myBaitsParams) {
        Map paramMap = (Map)myBaitsParams;
        return paramMap.get("t");
    }

    private String[] findUpdateFields(Object myBaitsParams, String entityParamName, boolean ignoreNullValueField) {
        Map paramMap = (Map)myBaitsParams;
        Object entity = paramMap.get(entityParamName);
        ArrayList<CallSite> updateFields = new ArrayList<CallSite>();
        List<Field> fields = super.getEntityNotStaticFields(entity, ignoreNullValueField);
        for (Field field : fields) {
            IgnoreField ignoreField = field.getAnnotation(IgnoreField.class);
            if (ignoreField != null || this.isIgnoreUpdateField(entity.getClass().getName(), field)) continue;
            String updateFieldStr = this.getDBFieldName(field) + "=#{" + entityParamName + "." + field.getName() + "}";
            updateFields.add((CallSite)((Object)updateFieldStr));
        }
        return updateFields.toArray(new String[0]);
    }

    private SqlCommand generateFromQueryBean(MethodParserResult result, Table table, String simpleName) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("update ");
        stringBuilder.append(this.findTableName(result.getPredicateAnno(), simpleName, table));
        stringBuilder.append(SET);
        if (!result.sqlNeedMerge()) {
            stringBuilder.append(result.getPredicate().toSqlFrame(result.getPredicate().hasScript()));
        }
        return new SqlCommand(stringBuilder.toString(), SqlCommandType.UPDATE, true);
    }
}

