/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate;

import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.dal.SqlCommand;
import com.cyberway.mp.bc.dal.annotation.Join;
import com.cyberway.mp.bc.dal.annotation.Table;
import com.cyberway.mp.bc.dal.dynamicquery.DynamicQuery;
import com.cyberway.mp.bc.dal.dynamicquery.QuerySqlGen;
import com.cyberway.mp.bc.dal.generate.AbstractSqlGenerator;
import com.cyberway.mp.bc.dal.generate.parser.MethodParser;
import com.cyberway.mp.bc.dal.generate.parser.MethodParserResult;
import com.cyberway.mp.bc.dal.generate.parser.Pageable;
import com.cyberway.mp.bc.dal.generate.parser.Predicate;
import com.cyberway.mp.bc.dal.util.EntityUtils;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.ibatis.mapping.SqlCommandType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.stereotype.Component;

@Component
public class SearchGenerator
extends AbstractSqlGenerator {
    private static final String PREFIX_SEARCH = "search";
    private static final String WHERE = "where";
    @Autowired
    private MethodParser methodParser;

    public void setMethodParser(MethodParser methodParser) {
        this.methodParser = methodParser;
    }

    @Override
    public boolean match(Method method) {
        String name = method.getName();
        return this.match(name);
    }

    @Override
    public boolean match(String methodName) {
        return methodName.startsWith(PREFIX_SEARCH);
    }

    @Override
    public SqlCommand merge(Method method, Class<?> mapper, Object target, String sqlFrame) {
        if (this.isDynamicQuery(method)) {
            return this.dynamicQueryMerge(target, sqlFrame);
        }
        return this.commonMerge(target, sqlFrame);
    }

    private SqlCommand dynamicQueryMerge(Object target, String sqlFrame) {
        Triple<PageParam, DynamicQuery, String> triple = this.findPageAndDynamicObject(target);
        DynamicQuery dynamicQuery = (DynamicQuery)triple.getMiddle();
        QuerySqlGen querySqlGen = new QuerySqlGen((String)triple.getRight(), this.sqlEscape);
        dynamicQuery.accept(querySqlGen);
        String partSql = querySqlGen.getSql();
        sqlFrame = (String)sqlFrame + partSql;
        if (triple.getLeft() != null) {
            StringBuilder stringBuilder = new StringBuilder();
            this.addPageable(target, (String)sqlFrame, (PageParam)triple.getLeft(), stringBuilder);
            sqlFrame = (String)sqlFrame + stringBuilder;
        }
        return new SqlCommand((String)sqlFrame, SqlCommandType.SELECT);
    }

    private SqlCommand commonMerge(Object target, String sqlFrame) {
        boolean mergeWhere = !sqlFrame.contains(WHERE);
        Triple<PageParam, Object, String> triple = this.findPageAndQueryObject(mergeWhere, target);
        StringBuilder stringBuilder = new StringBuilder();
        Predicate predicate = null;
        if (mergeWhere && triple.getMiddle() != null && (predicate = triple.getRight() != null ? this.mergePredicate(triple.getMiddle(), true, (String)triple.getRight(), true) : this.mergePredicate(triple.getMiddle(), false, null, true)) != null) {
            stringBuilder.append(predicate.toSqlFrame(predicate.hasScript()));
        }
        if (triple.getLeft() != null) {
            this.addPageable(target, sqlFrame, (PageParam)triple.getLeft(), stringBuilder);
        }
        Object sql = sqlFrame + stringBuilder;
        if (predicate != null && predicate.hasScript()) {
            sql = String.format("<script>%s</script>", sql);
        }
        return new SqlCommand((String)sql, SqlCommandType.SELECT);
    }

    private Triple<PageParam, Object, String> findPageAndQueryObject(boolean mergeWhere, Object target) {
        PageParam pageparam = null;
        Object query = null;
        String queryEntityName = null;
        if (target instanceof Map) {
            Map paramMap = (Map)target;
            for (Map.Entry entry : paramMap.entrySet()) {
                if (entry.getValue() instanceof PageParam) {
                    pageparam = (PageParam)entry.getValue();
                }
                if (!mergeWhere || entry.getValue().getClass().getAnnotation(com.cyberway.mp.bc.dal.annotation.Predicate.class) == null) continue;
                query = entry.getValue();
                queryEntityName = (String)entry.getKey();
            }
        } else {
            query = target;
        }
        return Triple.of(pageparam, (Object)query, queryEntityName);
    }

    @Override
    public SqlCommand generate(Method method, Class<?> mapper) {
        if (this.isDynamicQuery(method)) {
            MethodParserResult result = this.methodParser.parseForDynamicQuery(method, mapper);
            StringBuilder stringBuilder = new StringBuilder();
            this.addSelect(stringBuilder, result);
            return new SqlCommand(stringBuilder.toString(), SqlCommandType.SELECT, true);
        }
        Class<?> entityClass = EntityUtils.getEntityClass(mapper);
        MethodParserResult result = this.methodParser.parse(method, mapper);
        String sql = this.generateSql(result, entityClass);
        if (result.sqlNeedMerge() || result.isHasPageParam()) {
            return new SqlCommand(sql, SqlCommandType.SELECT, true);
        }
        return new SqlCommand(sql, SqlCommandType.SELECT);
    }

    private String generateSql(MethodParserResult result, Class<?> entityClass) {
        StringBuilder stringBuilder = new StringBuilder();
        this.addSelect(stringBuilder, result);
        Join join = result.getJoin();
        stringBuilder.append(" from ");
        if (join != null) {
            stringBuilder.append(join.script());
        } else {
            String tableName = this.findTableName(result.getPredicateAnno(), entityClass.getSimpleName(), (Table)AnnotationUtils.getAnnotation(entityClass, Table.class));
            stringBuilder.append(tableName);
        }
        if (!result.getPredicateAnno().dynamic()) {
            stringBuilder.append(result.getPredicate().toSqlFrame(result.getPredicate().hasScript()));
        }
        return stringBuilder.toString();
    }

    private void addSelect(StringBuilder stringBuilder, MethodParserResult result) {
        stringBuilder.append(" select ");
        List<String> colStrings = this.cols(result);
        stringBuilder.append(String.join((CharSequence)",", colStrings.toArray(new String[0])));
    }

    private void addPageable(Object target, String sqlFrame, PageParam pageParam, StringBuilder stringBuilder) {
        String pageParamName = this.findPageParamName(target);
        Pageable pageable = new Pageable(pageParam, this.dalProperties, pageParamName);
        if (this.needAddDefaultOrderBy(true, sqlFrame, stringBuilder.toString())) {
            stringBuilder.append(" order by id ");
        }
        stringBuilder.append(pageable.toSqlFrame(pageable.hasScript()));
    }
}

