/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate;

import com.cyberway.mp.bc.dal.generate.CountGenerator;
import com.cyberway.mp.bc.dal.generate.DeleteGenerator;
import com.cyberway.mp.bc.dal.generate.FindGenerator;
import com.cyberway.mp.bc.dal.generate.InterceptSqlGenerator;
import com.cyberway.mp.bc.dal.generate.ModifyGenerator;
import com.cyberway.mp.bc.dal.generate.SearchGenerator;
import com.cyberway.mp.bc.dal.generate.SqlGenerator;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SqlGeneratorFactory
implements InitializingBean {
    @Autowired
    private FindGenerator findGenerator;
    @Autowired
    private ModifyGenerator modifyGenerator;
    @Autowired
    private DeleteGenerator deleteGenerator;
    @Autowired
    private CountGenerator countGenerator;
    @Autowired
    private SearchGenerator searchGenerator;
    private List<SqlGenerator> generators = new ArrayList<SqlGenerator>();
    private List<InterceptSqlGenerator> interceptSqlGenerators = new ArrayList<InterceptSqlGenerator>();

    public SqlGenerator find(Method method) {
        for (SqlGenerator generator : this.generators) {
            if (!generator.match(method)) continue;
            return generator;
        }
        return null;
    }

    public InterceptSqlGenerator findWhenIntercept(String method) {
        for (InterceptSqlGenerator generator : this.interceptSqlGenerators) {
            if (!generator.match(method)) continue;
            return generator;
        }
        return null;
    }

    public void afterPropertiesSet() throws Exception {
        this.generators.add(this.findGenerator);
        this.generators.add(this.modifyGenerator);
        this.generators.add(this.deleteGenerator);
        this.generators.add(this.countGenerator);
        this.generators.add(this.searchGenerator);
        this.interceptSqlGenerators.add(this.modifyGenerator);
        this.interceptSqlGenerators.add(this.searchGenerator);
        this.interceptSqlGenerators.add(this.countGenerator);
        this.interceptSqlGenerators.add(this.findGenerator);
        this.interceptSqlGenerators.add(this.deleteGenerator);
    }
}

