/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate.dialect;

import com.cyberway.mp.bc.dal.generate.dialect.BatchGenerator;
import com.cyberway.mp.bc.dal.util.SqlEscape;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class AbstractBatchGenerator
implements BatchGenerator {
    protected static final String BATCH_INSERT_PARAMS = "entities";
    protected static final String ID_FIELD_NAME = "id";
    private static final String COLLECTION_FRAGMENT = "<foreach item='item' collection='";
    @Autowired
    protected SqlEscape sqlEscape;

    protected AbstractBatchGenerator(SqlEscape sqlEscape) {
        this.sqlEscape = sqlEscape;
    }

    @Override
    public StringBuilder batchInsert(String tableName, List<String> insertField, List<String> insertFieldParam) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<script> insert into ");
        stringBuilder.append(tableName);
        stringBuilder.append(" ( ");
        stringBuilder.append(StringUtils.join(insertField, (String)","));
        stringBuilder.append(" ) values ");
        stringBuilder.append(COLLECTION_FRAGMENT).append(BATCH_INSERT_PARAMS).append("' separator=','>(");
        stringBuilder.append(StringUtils.join(insertFieldParam, (String)","));
        stringBuilder.append(")</foreach>");
        stringBuilder.append("</script>");
        return stringBuilder;
    }

    @Override
    public StringBuilder batchUpdate(String tableName, List<String> updateFields, List<String> updateFieldParams) {
        String idFieldParam = this.findIDFieldParam(updateFields, updateFieldParams);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<script> update ");
        stringBuilder.append(tableName);
        stringBuilder.append(" set ");
        for (int i = 0; i < updateFields.size(); ++i) {
            String updateField = updateFields.get(i);
            if (this.isIDField(updateField)) continue;
            stringBuilder.append(updateField);
            stringBuilder.append("=");
            stringBuilder.append(COLLECTION_FRAGMENT).append(BATCH_INSERT_PARAMS).append("' separator=' ' open='case ID' close='end'>");
            stringBuilder.append(" when ");
            stringBuilder.append(idFieldParam);
            stringBuilder.append(" then ");
            stringBuilder.append(updateFieldParams.get(i));
            stringBuilder.append("</foreach>");
            stringBuilder.append(",");
        }
        stringBuilder = stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append(" where ");
        stringBuilder.append(this.sqlEscape.escapeColName(ID_FIELD_NAME));
        stringBuilder.append(" in ");
        stringBuilder.append(COLLECTION_FRAGMENT).append(BATCH_INSERT_PARAMS).append("' separator=',' open='(' close=')'>");
        stringBuilder.append(idFieldParam);
        stringBuilder.append("</foreach>");
        stringBuilder.append("</script>");
        return stringBuilder;
    }

    private String findIDFieldParam(List<String> updateFields, List<String> updateFieldParams) {
        for (int i = 0; i < updateFields.size(); ++i) {
            String updateField = updateFields.get(i);
            if (!this.isIDField(updateField)) continue;
            return updateFieldParams.get(i);
        }
        throw new IllegalArgumentException(" batchUpdate arg must has ID field");
    }

    protected boolean isIDField(String updateField) {
        return updateField.equalsIgnoreCase(this.sqlEscape.escapeColName(ID_FIELD_NAME));
    }

    protected void addIDEq(StringBuilder stringBuilder, List<String> updateFields, List<String> updateFieldParams) {
        for (int i = 0; i < updateFields.size(); ++i) {
            String updateField = updateFields.get(i);
            if (!this.isIDField(updateField)) continue;
            stringBuilder.append(updateField);
            stringBuilder.append("=");
            stringBuilder.append(updateFieldParams.get(i));
        }
    }
}

