/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate.dialect;

import com.cyberway.mp.bc.dal.config.Dialect;
import com.cyberway.mp.bc.dal.generate.dialect.BatchGenerator;
import com.cyberway.mp.bc.dal.generate.dialect.DMBatchGenerator;
import com.cyberway.mp.bc.dal.generate.dialect.MysqlBatchGenerator;
import com.cyberway.mp.bc.dal.generate.dialect.OracleBatchGenerator;
import com.cyberway.mp.bc.dal.generate.dialect.PostgreSqlBatchGenerator;
import com.cyberway.mp.bc.dal.generate.dialect.SqlServerBatchGenerator;
import java.util.HashMap;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class BatchGeneratorFactory {
    private Map<String, BatchGenerator> generatorMap = new HashMap<String, BatchGenerator>();

    public BatchGeneratorFactory(DMBatchGenerator dmBatchGenerator, MysqlBatchGenerator mysqlBatchGenerator, OracleBatchGenerator oracleBatchGenerator, PostgreSqlBatchGenerator postgreSqlBatchGenerator, SqlServerBatchGenerator sqlServerBatchGenerator) {
        this.generatorMap.put(Dialect.MYSQL.name(), mysqlBatchGenerator);
        this.generatorMap.put(Dialect.H2.name(), mysqlBatchGenerator);
        this.generatorMap.put(Dialect.ORACLE.name(), oracleBatchGenerator);
        this.generatorMap.put(Dialect.POSTGRESQL.name(), postgreSqlBatchGenerator);
        this.generatorMap.put(Dialect.SQLSERVER.name(), sqlServerBatchGenerator);
        this.generatorMap.put(Dialect.DM.name(), dmBatchGenerator);
    }

    public BatchGenerator getBatchGenerator(String dialect) {
        return this.generatorMap.get(dialect.toUpperCase());
    }
}

