/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate.dialect;

import com.cyberway.mp.bc.dal.generate.dialect.AbstractBatchGenerator;
import com.cyberway.mp.bc.dal.util.SqlEscape;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
public class OracleBatchGenerator
extends AbstractBatchGenerator {
    public OracleBatchGenerator(SqlEscape sqlEscape) {
        super(sqlEscape);
    }

    @Override
    public StringBuilder batchInsert(String tableName, List<String> insertField, List<String> insertFieldParam) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<script> insert all ");
        stringBuilder.append("<foreach item='item' collection='").append("entities").append("' separator=' '>");
        stringBuilder.append(" into ");
        stringBuilder.append(tableName);
        stringBuilder.append(" ( ");
        stringBuilder.append(StringUtils.join(insertField, (String)","));
        stringBuilder.append(" ) values ( ");
        stringBuilder.append(StringUtils.join(insertFieldParam, (String)","));
        stringBuilder.append(")</foreach>");
        stringBuilder.append("SELECT 1 FROM DUAL");
        stringBuilder.append("</script>");
        return stringBuilder;
    }

    @Override
    public StringBuilder batchUpdate(String tableName, List<String> updateFields, List<String> updateFieldParams) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<script> begin ");
        stringBuilder.append("<foreach item='item' collection='").append("entities").append("' separator=';'>");
        stringBuilder.append(" update ");
        stringBuilder.append(tableName);
        stringBuilder.append(" <set> ");
        for (int i = 0; i < updateFields.size(); ++i) {
            String updateField = updateFields.get(i);
            if (this.isIDField(updateField)) continue;
            stringBuilder.append(updateField);
            stringBuilder.append("=");
            stringBuilder.append(updateFieldParams.get(i));
            stringBuilder.append(",");
        }
        stringBuilder = stringBuilder.deleteCharAt(stringBuilder.length() - 1);
        stringBuilder.append("</set>");
        stringBuilder.append(" where ");
        this.addIDEq(stringBuilder, updateFields, updateFieldParams);
        stringBuilder.append("</foreach>");
        stringBuilder.append(";end;");
        stringBuilder.append("</script>");
        return stringBuilder;
    }
}

