/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate.parser;

import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.annotation.Alias;
import com.cyberway.mp.bc.dal.annotation.query.IgnoreField;
import com.cyberway.mp.bc.dal.generate.parser.Column;
import com.cyberway.mp.bc.dal.util.EntityUtils;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;

public class BeanColumn {
    private final List<Column> columns = new ArrayList<Column>();

    public BeanColumn(Class<?> resultBean) {
        this(null, resultBean);
    }

    public BeanColumn(String baseAlias, Class<?> resultBean) {
        List<Field> fields = EntityUtils.getEntityNotStaticFields(resultBean);
        boolean hasBaseAlias = StringUtils.isNotBlank((CharSequence)baseAlias);
        for (Field field : fields) {
            String fieldName = field.getName();
            IgnoreField ignoreField = field.getAnnotation(IgnoreField.class);
            if (ignoreField != null) continue;
            Alias alias = (Alias)AnnotationUtils.getAnnotation((AnnotatedElement)field, Alias.class);
            if (alias != null && StringUtils.isNotBlank((CharSequence)alias.name())) {
                this.columns.add(new Column(fieldName, alias.name()));
                continue;
            }
            if (hasBaseAlias) {
                this.columns.add(new Column(fieldName, baseAlias + "." + Strings.underscoreName((String)fieldName)));
                continue;
            }
            this.columns.add(new Column(fieldName));
        }
    }

    public List<Column> getColumns() {
        return this.columns;
    }
}

