/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate.parser;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.dal.generate.parser.Columns;
import com.cyberway.mp.bc.dal.generate.parser.ParserResult;
import com.cyberway.mp.bc.dal.generate.parser.Predicate;
import com.cyberway.mp.bc.dal.util.SqlEscape;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class MethodNameParser {
    private static final String BY_PATTERN = "(?<!Order)By";
    private static final String REPLICA_STR = "#";
    @Autowired
    private SqlEscape sqlEscape;

    public void setSqlEscape(SqlEscape sqlEscape) {
        this.sqlEscape = sqlEscape;
    }

    public ParserResult parse(String methodRemovePrefix) {
        Pattern pattern = Pattern.compile(BY_PATTERN);
        Matcher matcher = pattern.matcher(methodRemovePrefix);
        if (!matcher.find()) {
            throw new BaseException("00000001", "\u65b9\u6cd5\u5b9a\u4e49\u9519\u8bef\uff0c\u5fc5\u987b\u6709By\u5173\u952e\u5b57");
        }
        String methodReplaceStr = methodRemovePrefix.replaceFirst(BY_PATTERN, REPLICA_STR);
        String[] split = methodReplaceStr.split(REPLICA_STR);
        if (StringUtils.hasText((String)split[0])) {
            return new ParserResult(new Predicate(split[1], this.sqlEscape), new Columns(split[0]));
        }
        return new ParserResult(new Predicate(split[1], this.sqlEscape), null);
    }
}

