/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate.parser;

import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.dal.annotation.Join;
import com.cyberway.mp.bc.dal.annotation.ResultBeanAlias;
import com.cyberway.mp.bc.dal.annotation.query.IgnoreField;
import com.cyberway.mp.bc.dal.generate.parser.BeanColumn;
import com.cyberway.mp.bc.dal.generate.parser.MethodParserResult;
import com.cyberway.mp.bc.dal.generate.parser.Predicate;
import com.cyberway.mp.bc.dal.util.EntityUtils;
import com.cyberway.mp.bc.dal.util.SqlEscape;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.MethodParameter;
import org.springframework.stereotype.Component;

@Component
public class MethodParser {
    @Autowired
    private SqlEscape sqlEscape;

    public void setSqlEscape(SqlEscape sqlEscape) {
        this.sqlEscape = sqlEscape;
    }

    public MethodParserResult parse(Method method, Class<?> mapper) {
        return this.parse(method, mapper, true);
    }

    public MethodParserResult parse(Method method, Class<?> mapper, boolean isSearch) {
        MethodParserResult methodParserResult;
        Parameter[] params = method.getParameters();
        boolean hasPageParam = false;
        com.cyberway.mp.bc.dal.annotation.Predicate predicate = null;
        Join join = null;
        List<Field> fields = null;
        String entityName = "";
        for (Parameter param : params) {
            if (!param.getType().equals(PageParam.class)) continue;
            hasPageParam = true;
            break;
        }
        Parameter[] parameters = method.getParameters();
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            MethodParameter methodParameter = new MethodParameter(method, i, i + 1);
            Class aClass = methodParameter.withContainingClass(mapper).getParameterType();
            predicate = aClass.getAnnotation(com.cyberway.mp.bc.dal.annotation.Predicate.class);
            if (predicate == null) continue;
            if (!predicate.dynamic()) {
                fields = EntityUtils.getEntityNotStaticFields(aClass);
            }
            entityName = parameter.getName();
            join = aClass.getAnnotation(Join.class);
            break;
        }
        if (predicate == null) {
            String errorMessage = String.format("\u65b9\u6cd5: %s \u5fc5\u987b\u6709\u4e00\u4e2a\u4f7f\u7528 Predicate \u6ce8\u89e3\u6807\u8bb0", method.getName());
            throw new BaseException("00000002", errorMessage);
        }
        BeanColumn column = null;
        if (isSearch) {
            column = this.findBeanColumn(method, mapper);
        }
        if (predicate.dynamic()) {
            methodParserResult = new MethodParserResult(null, column, predicate, hasPageParam);
        } else {
            if (null != fields) {
                fields = fields.stream().filter(field -> null == field.getAnnotation(IgnoreField.class)).collect(Collectors.toList());
            }
            methodParserResult = new MethodParserResult(new Predicate(fields, hasPageParam, hasPageParam ? entityName : "", this.sqlEscape), column, predicate, hasPageParam);
        }
        methodParserResult.setJoin(join);
        return methodParserResult;
    }

    private BeanColumn findBeanColumn(Method method, Class<?> mapper) {
        Class returnType;
        try {
            ParameterizedType type = (ParameterizedType)method.getGenericReturnType();
            returnType = (Class)type.getActualTypeArguments()[0];
        }
        catch (Exception e) {
            returnType = EntityUtils.getEntityClass(mapper);
        }
        if (returnType == null) {
            String errorMessage = String.format("\u65b9\u6cd5: %s \u627e\u4e0d\u5230\u8fd4\u56de\u7684\u7c7b\u578b", method.getName());
            throw new BaseException("00000002", errorMessage);
        }
        ResultBeanAlias resultBeanAlias = method.getAnnotation(ResultBeanAlias.class);
        if (resultBeanAlias != null) {
            return new BeanColumn(resultBeanAlias.value(), returnType);
        }
        return new BeanColumn(returnType);
    }

    public MethodParserResult parseForDynamicQuery(Method method, Class<?> mapper) {
        boolean hasPageParam = false;
        for (Parameter param : method.getParameters()) {
            if (!param.getType().equals(PageParam.class)) continue;
            hasPageParam = true;
            break;
        }
        return new MethodParserResult(null, this.findBeanColumn(method, mapper), null, hasPageParam);
    }
}

