/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate.parser;

import com.cyberway.mp.bc.dal.generate.parser.Predicate;
import com.cyberway.mp.bc.dal.util.SqlEscape;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class OrPartParser {
    private static final char EOF = '\uffff';
    private static final int NEXT_TWO_CHAR = 2;
    private final String partStr;
    private char currentChar;
    private int currentIndex = 0;
    private StringBuilder buf = new StringBuilder();
    private SqlEscape sqlEscape;

    public OrPartParser(String partStr, SqlEscape sqlEscape) {
        this.partStr = partStr;
        if (StringUtils.isNotBlank((CharSequence)partStr)) {
            this.currentChar = partStr.charAt(this.currentIndex);
        }
        this.sqlEscape = sqlEscape;
    }

    public List<Predicate.OrPart> parse() {
        if (StringUtils.isBlank((CharSequence)this.partStr)) {
            return Collections.emptyList();
        }
        ArrayList<Predicate.OrPart> orParts = new ArrayList<Predicate.OrPart>();
        while (this.currentChar != '\uffff') {
            switch (this.currentChar) {
                case 'O': {
                    this.handlerMetO(orParts);
                }
            }
            this.buf.append(this.currentChar);
            this.consume();
        }
        if (this.buf.length() > 0) {
            orParts.add(new Predicate.OrPart(this.buf.toString(), this.sqlEscape));
        }
        return orParts;
    }

    private void handlerMetO(List<Predicate.OrPart> orParts) {
        char aheadChar = this.lookAhead(1);
        if (aheadChar == 'r' && Character.isUpperCase(aheadChar = this.lookAhead(2)) && this.buf.length() > 0) {
            orParts.add(new Predicate.OrPart(this.buf.toString(), this.sqlEscape));
            this.consume();
            this.consume();
            this.buf = new StringBuilder();
            return;
        }
        this.buf.append(this.currentChar);
        this.consume();
    }

    private char lookAhead(int aheadPos) {
        int aheadIndex = this.currentIndex + aheadPos;
        if (aheadIndex >= this.partStr.length()) {
            return '\uffff';
        }
        return this.partStr.charAt(aheadIndex);
    }

    private void consume() {
        ++this.currentIndex;
        this.currentChar = this.currentIndex >= this.partStr.length() ? (char)65535 : this.partStr.charAt(this.currentIndex);
    }
}

