/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate.parser;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.dal.generate.parser.SqlFrame;
import java.util.Locale;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Order
implements SqlFrame {
    public static final Direction DEFAULT_DIRECTION = Direction.ASC;
    private static final Logger log = LoggerFactory.getLogger(Order.class);
    private final Direction direction;
    private final String property;
    private int order;

    public Order(Direction direction, String property) {
        this(direction, property, 0);
    }

    public Order(Direction direction, String property, int order) {
        this.direction = direction == null ? DEFAULT_DIRECTION : direction;
        this.property = property;
        this.order = order;
    }

    @Override
    public String toSqlFrame(boolean scriptContent) {
        return this.property + " " + this.direction;
    }

    public int getOrder() {
        return this.order;
    }

    @Override
    public boolean hasScript() {
        return false;
    }

    public static enum Direction {
        ASC,
        DESC;


        public static Direction fromString(String value) {
            try {
                return Direction.valueOf(value.toUpperCase(Locale.US));
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new BaseException("00000001", String.format("Invalid value '%s' for orders given! Has to be either 'desc' or 'asc' (case insensitive).", value));
            }
        }

        public static Optional<Direction> fromOptionalString(String value) {
            try {
                return Optional.of(Direction.fromString(value));
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }
    }
}

