/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate.parser;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.annotation.Alias;
import com.cyberway.mp.bc.dal.annotation.OrderBy;
import com.cyberway.mp.bc.dal.annotation.query.OrderByField;
import com.cyberway.mp.bc.dal.generate.parser.Order;
import com.cyberway.mp.bc.dal.generate.parser.SqlFrame;
import com.cyberway.mp.bc.dal.model.OrderFragment;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;

public class OrderBySource
implements SqlFrame {
    public static final String ORDER_BY_STR = " ORDER BY ";
    public static final OrderBySource EMPTY = new OrderBySource("");
    private static final String BLOCK_SPLIT = "(?<=Asc|Desc)(?=\\p{Lu})";
    private static final Pattern DIRECTION_SPLIT = Pattern.compile("(.+?)(Asc|Desc)?$");
    private static final String INVALID_ORDER_SYNTAX = "Invalid order syntax for part %s!";
    private static final Set<String> DIRECTION_KEYWORDS = new HashSet<String>(Arrays.asList("Asc", "Desc"));
    private static final Logger log = LoggerFactory.getLogger(OrderBySource.class);
    private final List<Order> orders = new ArrayList<Order>();

    OrderBySource(String clause) {
        if (StringUtils.isBlank((CharSequence)clause)) {
            return;
        }
        for (String part : clause.split(BLOCK_SPLIT)) {
            Matcher matcher = DIRECTION_SPLIT.matcher(part);
            if (!matcher.find()) {
                throw new IllegalArgumentException(String.format(INVALID_ORDER_SYNTAX, part));
            }
            String propertyString = matcher.group(1);
            String directionString = matcher.group(2);
            if (DIRECTION_KEYWORDS.contains(propertyString) && directionString == null) {
                throw new IllegalArgumentException(String.format(INVALID_ORDER_SYNTAX, part));
            }
            this.orders.add(this.createOrder(Strings.underscoreName((String)propertyString), Order.Direction.fromString(directionString)));
        }
    }

    public OrderBySource(List<Field> fields, boolean isMergeStage, Object queryBean) {
        int order = 0;
        for (Field field : fields) {
            OrderByField orderByField;
            OrderBy orderBy = field.getAnnotation(OrderBy.class);
            if (orderBy != null) {
                Order.Direction direction = orderBy.asc() ? Order.Direction.ASC : Order.Direction.DESC;
                order = orderBy.order();
                Alias alias = (Alias)AnnotationUtils.getAnnotation((AnnotatedElement)field, Alias.class);
                if (alias != null && StringUtils.isNotBlank((CharSequence)alias.name())) {
                    this.orders.add(new Order(direction, alias.name(), order));
                } else {
                    this.orders.add(new Order(direction, Strings.underscoreName((String)field.getName()), order));
                }
            }
            if ((orderByField = field.getAnnotation(OrderByField.class)) == null) continue;
            this.handleOrderByField(field, queryBean, orderByField);
        }
    }

    private void handleOrderByField(Field field, Object queryBean, OrderByField orderByField) {
        Object fieldObject = null;
        try {
            field.setAccessible(true);
            fieldObject = field.get(queryBean);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BaseException("00000001", String.format("\u4e0d\u80fd\u83b7\u53d6\u6392\u5e8f\u5b57\u6bb5\uff1a '%s' \u7684\u503c.", field.getName()));
        }
        int order = orderByField.order();
        if (fieldObject != null) {
            if (fieldObject instanceof OrderFragment) {
                this.handleOrderFragment(order, fieldObject);
            } else if (fieldObject instanceof String) {
                Order.Direction direction = Order.Direction.fromString(fieldObject.toString());
                this.orders.add(new Order(direction, Strings.underscoreName((String)field.getName()), order));
            } else if (fieldObject instanceof List) {
                List orderFragments = (List)fieldObject;
                for (Object eachFieldObject : orderFragments) {
                    if (!(eachFieldObject instanceof OrderFragment)) continue;
                    this.handleOrderFragment(order, eachFieldObject);
                }
            }
        }
    }

    private void handleOrderFragment(int order, Object fieldObject) {
        OrderFragment orderFragment = (OrderFragment)fieldObject;
        Order.Direction direction = Order.Direction.fromString(orderFragment.getDirection());
        this.orders.add(new Order(direction, orderFragment.getFieldName(), order));
    }

    private Order createOrder(String propertySource, Order.Direction direction) {
        return new Order(direction, propertySource);
    }

    @Override
    public String toSqlFrame(boolean scriptContent) {
        if (this.orders.isEmpty()) {
            return "";
        }
        this.orders.sort(Comparator.comparingInt(Order::getOrder));
        return ORDER_BY_STR + String.join((CharSequence)",", (CharSequence[])this.orders.stream().map(order -> order.toSqlFrame(scriptContent)).toArray(String[]::new)) + " ";
    }

    @Override
    public boolean hasScript() {
        return false;
    }
}

