/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate.parser;

import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.dal.config.DALProperties;
import com.cyberway.mp.bc.dal.generate.parser.SqlFrame;

public class Pageable
implements SqlFrame {
    private static final String ROW_PARAM = "pageSize";
    private static final String OFFSET_PARAM = "offset";
    private final String rowParam;
    private final String offsetParam;
    private final DALProperties dalProperties;

    public Pageable(PageParam pageParam, DALProperties dalProperties, String pageParamName) {
        this.dalProperties = dalProperties;
        this.rowParam = "#{" + pageParamName + ".pageSize}";
        this.offsetParam = "#{" + pageParamName + ".offset}";
    }

    @Override
    public String toSqlFrame(boolean scriptContent) {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.dalProperties.currentDialectIsMysqlOrH2()) {
            stringBuilder.append(" limit ");
            stringBuilder.append(this.offsetParam);
            stringBuilder.append(",");
            stringBuilder.append(this.rowParam);
        } else if (this.dalProperties.currentDialectIsOracleOrSqlServer() || this.dalProperties.currentDialectIsDM()) {
            stringBuilder.append(" offset ");
            stringBuilder.append(this.offsetParam);
            stringBuilder.append(" rows fetch next ");
            stringBuilder.append(this.rowParam);
            stringBuilder.append(" rows only ");
        } else if (this.dalProperties.currentDialectIsPostgresql()) {
            stringBuilder.append(" limit ");
            stringBuilder.append(this.rowParam);
            stringBuilder.append(" offset ");
            stringBuilder.append(this.offsetParam);
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean hasScript() {
        return false;
    }
}

