/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate.parser;

import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.annotation.Alias;
import com.cyberway.mp.bc.dal.generate.parser.SqlFrame;
import com.cyberway.mp.bc.dal.util.SqlEscape;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class Part
implements SqlFrame {
    private Type type;
    private String property;
    private String dbFieldName;

    public Part(String source, SqlEscape sqlEscape) {
        this.type = Type.fromProperty(source);
        this.property = this.type.extractProperty(source);
        this.dbFieldName = sqlEscape.escapeColName(Strings.underscoreName((String)this.property));
    }

    public Part(Field field, boolean isNeedEntityPrefix, String entityPrefix, SqlEscape sqlEscape) {
        Annotation[] annotations;
        this.property = field.getName();
        for (Annotation anno : annotations = field.getAnnotations()) {
            Type annoType;
            if (anno instanceof Alias && StringUtils.isNotBlank((CharSequence)this.aliasValue((Alias)anno))) {
                this.dbFieldName = this.aliasValue((Alias)anno);
            }
            if ((annoType = Type.fromAnnotation(anno)) == null) continue;
            this.type = annoType;
        }
        if (StringUtils.isEmpty((CharSequence)this.dbFieldName)) {
            this.dbFieldName = Strings.underscoreName((String)this.property);
        }
        if (isNeedEntityPrefix) {
            this.property = entityPrefix + "." + this.property;
        }
        if (this.type == null) {
            this.type = Type.SIMPLE_PROPERTY;
        }
        this.dbFieldName = sqlEscape.escapeColName(this.dbFieldName);
    }

    private String aliasValue(Alias alias) {
        if (StringUtils.isNotBlank((CharSequence)alias.name())) {
            return alias.name();
        }
        return alias.value();
    }

    @Override
    public String toSqlFrame(boolean scriptContent) {
        return this.type.toSqlFrame(this.dbFieldName, this.property, scriptContent);
    }

    @Override
    public boolean hasScript() {
        return this.type.isHasScript();
    }

    public static enum Type {
        BETWEEN(" %s between %s and %s ", 2, "Between"),
        IS_NOT_NULL(" %s is not null ", 0, "IsNotNull", "NotNull"),
        IS_NULL(" %s is null ", 0, "IsNull", "Null"),
        LESS_THAN(" %s &lt; %s ", false, " %s < %s ", "LessThan"),
        LESS_THAN_EQUAL(" %s &lt;= %s ", false, " %s <= %s ", "LessThanEqual"),
        GREATER_THAN(" %s &gt; %s ", false, " %s > %s ", "GreaterThan"),
        GREATER_THAN_EQUAL(" %s &gt;= %s ", false, " %s >= %s ", "GreaterThanEqual"),
        BEFORE(" %s &lt; %s ", false, " %s < %s ", "Before"),
        AFTER(" %s &gt; %s ", false, " %s > %s ", "After"),
        NOT_LIKE(" %s not like %s ", "NotLike"),
        LIKE(" %s like %s ", "Like"),
        STARTING_WITH(" %s like CONCAT(%s,&apos;%%&apos;) ", false, " %s like CONCAT(%s,'%%')", "StartingWith", "StartsWith"),
        ENDING_WITH(" %s like CONCAT(&apos;%%&apos;,%s) ", false, " %s like CONCAT('%%',%s)", "EndingWith", "EndsWith"),
        NOT_CONTAINING(" %s not like CONCAT(CONCAT( &apos;%%&apos;, %s),  &apos;%%&apos;)", false, " %s not like CONCAT(CONCAT('%%', %s), '%%')", "NotContains"),
        CONTAINING(" %s like CONCAT(CONCAT( &apos;%%&apos;, %s),  &apos;%%&apos;)", false, " %s like CONCAT(CONCAT('%%', %s), '%%')", "Containing", "Contains"),
        NOT_IN(true, "  %s not in <foreach item='item' index='index' collection='%s' open='(' separator=',' close=')'>#{item}</foreach> ", "NotIn"),
        IN(true, "  %s in <foreach item='item' index='index' collection='%s' open='(' separator=',' close=')'>#{item}</foreach> ", "In"),
        TRUE(" %s = true ", 0, "True"),
        FALSE(" %s = false ", 0, "False"),
        NEGATING_SIMPLE_PROPERTY(" %s != %s ", "Not"),
        SIMPLE_PROPERTY(" %s = %s ", "Equals");

        private static final List<Type> ALL;
        private final List<String> keywords;
        private final int numberOfArguments;
        private final String opeFormat;
        private final boolean hasScript;
        private final String scriptOpFormat;

        private Type(String scriptOpFormat, boolean hasScript, String opeFormat, int numberOfArguments, String ... keywords) {
            this.scriptOpFormat = scriptOpFormat;
            this.opeFormat = opeFormat;
            this.numberOfArguments = numberOfArguments;
            this.keywords = Arrays.asList(keywords);
            this.hasScript = hasScript;
        }

        private Type(String opeFormat, int numberOfArguments, String ... keywords) {
            this("", false, opeFormat, numberOfArguments, keywords);
        }

        private Type(String scriptOpFormat, boolean hasScript, String opeFormat, String ... keywords) {
            this(scriptOpFormat, hasScript, opeFormat, 1, keywords);
        }

        private Type(String opeFormat, String ... keywords) {
            this("", false, opeFormat, 1, keywords);
        }

        private Type(boolean hasScript, String opeFormat, String ... keywords) {
            this("", hasScript, opeFormat, 1, keywords);
        }

        public static Type fromProperty(String rawProperty) {
            for (Type type : ALL) {
                if (!type.supports(rawProperty)) continue;
                return type;
            }
            return SIMPLE_PROPERTY;
        }

        public static Type fromAnnotation(Annotation annotation) {
            String annotationName = annotation.annotationType().getSimpleName();
            for (Type type : ALL) {
                if (!type.hasKeyWord(annotationName)) continue;
                return type;
            }
            return null;
        }

        private boolean hasKeyWord(String sqlKeyWord) {
            for (String keyword : this.keywords) {
                if (!sqlKeyWord.equalsIgnoreCase(keyword)) continue;
                return true;
            }
            return false;
        }

        private boolean supports(String property) {
            for (String keyword : this.keywords) {
                if (!property.endsWith(keyword)) continue;
                return true;
            }
            return false;
        }

        public String extractProperty(String part) {
            String candidate = Introspector.decapitalize(part);
            for (String keyword : this.keywords) {
                if (!candidate.endsWith(keyword)) continue;
                return candidate.substring(0, candidate.length() - keyword.length());
            }
            return candidate;
        }

        public String toSqlFrame(String dbFieldName, String property, boolean scriptContent) {
            String opeFormatter = this.opeFormat;
            if (scriptContent && StringUtils.isNotEmpty((CharSequence)this.scriptOpFormat)) {
                opeFormatter = this.scriptOpFormat;
            }
            if (this.numberOfArguments == 0) {
                return String.format(opeFormatter, dbFieldName);
            }
            if (this.numberOfArguments == 1 && !this.name().equalsIgnoreCase(IN.name()) && !this.name().equalsIgnoreCase(NOT_IN.name())) {
                return String.format(opeFormatter, dbFieldName, "#{" + property + "}");
            }
            if (this.numberOfArguments == 1) {
                return String.format(opeFormatter, dbFieldName, property);
            }
            if (this.numberOfArguments == 2) {
                return String.format(opeFormatter, dbFieldName, "#{" + property + "Start}", "#{" + property + "End}");
            }
            return null;
        }

        public boolean isHasScript() {
            return this.hasScript;
        }

        static {
            ALL = Arrays.asList(IS_NOT_NULL, IS_NULL, BETWEEN, LESS_THAN, LESS_THAN_EQUAL, GREATER_THAN, GREATER_THAN_EQUAL, BEFORE, AFTER, NOT_LIKE, LIKE, STARTING_WITH, ENDING_WITH, NOT_CONTAINING, CONTAINING, NOT_IN, IN, TRUE, FALSE, NEGATING_SIMPLE_PROPERTY, SIMPLE_PROPERTY);
        }
    }
}

