/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.generate.parser;

import com.cyberway.mp.bc.dal.annotation.LogicDelete;
import com.cyberway.mp.bc.dal.annotation.Or;
import com.cyberway.mp.bc.dal.annotation.OrderBy;
import com.cyberway.mp.bc.dal.annotation.query.IgnoreField;
import com.cyberway.mp.bc.dal.annotation.query.OrderByField;
import com.cyberway.mp.bc.dal.annotation.query.SubQuery;
import com.cyberway.mp.bc.dal.generate.DeletedValue;
import com.cyberway.mp.bc.dal.generate.parser.OrPartParser;
import com.cyberway.mp.bc.dal.generate.parser.OrderBySource;
import com.cyberway.mp.bc.dal.generate.parser.Part;
import com.cyberway.mp.bc.dal.generate.parser.SqlFrame;
import com.cyberway.mp.bc.dal.generate.parser.SubQueryPart;
import com.cyberway.mp.bc.dal.util.SqlEscape;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.util.StringUtils;

public class Predicate
implements SqlFrame {
    private static final String ORDER_BY = "OrderBy";
    private static final String AND = " and ";
    private final List<OrPart> nodes;
    private final OrderBySource orderBySource;
    private final List<SqlFrame> andNodes = new ArrayList<SqlFrame>();

    public Predicate(String predicate, SqlEscape sqlEscape) {
        String[] parts = org.apache.commons.lang3.StringUtils.splitByWholeSeparator((String)predicate, (String)ORDER_BY);
        if (parts.length > 2) {
            throw new IllegalArgumentException("OrderBy must not be used more than once in a method name!");
        }
        OrPartParser orPartParser = new OrPartParser(parts[0], sqlEscape);
        this.nodes = orPartParser.parse();
        this.orderBySource = parts.length == 2 ? new OrderBySource(parts[1]) : OrderBySource.EMPTY;
    }

    public Predicate(List<Field> fields, boolean isNeedEntity, String entityPrefix, SqlEscape sqlEscape) {
        this.nodes = new ArrayList<OrPart>();
        ArrayList<Field> orderFields = new ArrayList();
        if (fields != null) {
            orderFields = this.handlerFields(fields, isNeedEntity, entityPrefix, sqlEscape);
        }
        this.orderBySource = !orderFields.isEmpty() ? new OrderBySource(orderFields, false, null) : OrderBySource.EMPTY;
    }

    private List<Field> handlerFields(List<Field> fields, boolean isNeedEntity, String entityPrefix, SqlEscape sqlEscape) {
        ArrayList<Field> orderFields = new ArrayList<Field>();
        for (Field field : fields) {
            IgnoreField ignoreField = field.getAnnotation(IgnoreField.class);
            if (ignoreField != null) continue;
            OrderBy orderBy = field.getAnnotation(OrderBy.class);
            if (orderBy != null) {
                orderFields.add(field);
                continue;
            }
            Or or = field.getAnnotation(Or.class);
            if (or != null) {
                this.nodes.add(new OrPart(field, isNeedEntity, entityPrefix, sqlEscape));
                continue;
            }
            if (field.getAnnotation(SubQuery.class) != null) {
                this.andNodes.add(new SubQueryPart(field, isNeedEntity, entityPrefix));
                continue;
            }
            this.andNodes.add(new Part(field, isNeedEntity, entityPrefix, sqlEscape));
        }
        return orderFields;
    }

    public Predicate(List<Field> fields, boolean isNeedEntity, String entityPrefix, List<Field> orderFields, boolean isMergeStage, Object queryBean, SqlEscape sqlEscape) {
        this.nodes = new ArrayList<OrPart>();
        for (Field field : fields) {
            if (field.getAnnotation(IgnoreField.class) != null || field.getAnnotation(OrderByField.class) != null) continue;
            Or or = field.getAnnotation(Or.class);
            if (or != null) {
                this.nodes.add(new OrPart(field, isNeedEntity, entityPrefix, sqlEscape));
                continue;
            }
            if (field.getAnnotation(SubQuery.class) != null) {
                this.andNodes.add(new SubQueryPart(field, isNeedEntity, entityPrefix));
                continue;
            }
            this.andNodes.add(new Part(field, isNeedEntity, entityPrefix, sqlEscape));
        }
        this.orderBySource = !orderFields.isEmpty() ? new OrderBySource(orderFields, isMergeStage, queryBean) : OrderBySource.EMPTY;
    }

    @Override
    public String toSqlFrame(boolean scriptContent) {
        return this.toSqlFrame(scriptContent, null);
    }

    public String toSqlFrame(boolean scriptContent, LogicDelete logicDelete) {
        StringBuilder stringBuilder = new StringBuilder();
        String whereSql = this.whereFrame(scriptContent);
        boolean hasWhere = false;
        if (org.apache.commons.lang3.StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{whereSql})) {
            stringBuilder.append(" where ");
            stringBuilder.append(whereSql);
            hasWhere = true;
        }
        this.addLogicDeleteFrameIfNeed(stringBuilder, logicDelete, hasWhere);
        stringBuilder.append(this.orderBySource.toSqlFrame(scriptContent));
        return stringBuilder.toString();
    }

    private void addLogicDeleteFrameIfNeed(StringBuilder stringBuilder, LogicDelete logicDelete, boolean hasWhere) {
        if (logicDelete == null) {
            return;
        }
        if (hasWhere) {
            stringBuilder.append(AND);
        } else {
            stringBuilder.append(" where ");
        }
        stringBuilder.append(logicDelete.fieldName()).append("=").append(DeletedValue.NOT_DELETED.getDeleteValue());
    }

    private String whereFrame(boolean scriptContent) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.andNodes.isEmpty()) {
            stringBuilder.append(String.join((CharSequence)AND, (CharSequence[])this.andNodes.stream().map(node -> node.toSqlFrame(scriptContent)).toArray(String[]::new)));
        }
        if (!this.nodes.isEmpty()) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" or ");
            }
            stringBuilder.append(String.join((CharSequence)" or ", (CharSequence[])this.nodes.stream().map(node -> node.toSqlFrame(scriptContent)).toArray(String[]::new)));
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean hasScript() {
        for (SqlFrame part : this.andNodes) {
            if (!part.hasScript()) continue;
            return true;
        }
        for (OrPart orPart : this.nodes) {
            if (!orPart.hasScript()) continue;
            return true;
        }
        return false;
    }

    public static class OrPart
    implements SqlFrame {
        private final List<SqlFrame> children;

        OrPart(String source, SqlEscape sqlEscape) {
            String[] split = org.apache.commons.lang3.StringUtils.splitByWholeSeparator((String)source, (String)"And");
            this.children = Arrays.stream(split).filter(StringUtils::hasText).map(text -> new Part((String)text, sqlEscape)).collect(Collectors.toList());
        }

        OrPart(Field field, boolean isNeedEntityPrefix, String entityPrefix, SqlEscape sqlEscape) {
            this.children = new ArrayList<SqlFrame>();
            if (field.getAnnotation(SubQuery.class) != null) {
                this.children.add(new SubQueryPart(field, isNeedEntityPrefix, entityPrefix));
            } else {
                this.children.add(new Part(field, isNeedEntityPrefix, entityPrefix, sqlEscape));
            }
        }

        @Override
        public String toSqlFrame(boolean scriptContent) {
            if (this.children.isEmpty()) {
                return "";
            }
            if (this.children.size() == 1) {
                return this.children.get(0).toSqlFrame(scriptContent);
            }
            return String.join((CharSequence)Predicate.AND, (CharSequence[])this.children.stream().map(child -> child.toSqlFrame(scriptContent)).toArray(String[]::new));
        }

        @Override
        public boolean hasScript() {
            for (SqlFrame part : this.children) {
                if (!part.hasScript()) continue;
                return true;
            }
            return false;
        }
    }
}

