/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.handler;

import com.cyberway.mp.bc.common.utils.JsonUtils;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public abstract class AbstractJsonListTypeHandler<T>
extends BaseTypeHandler<List<T>> {
    private Class<T> clazz = null;

    protected AbstractJsonListTypeHandler(Class<T> clazz) {
        this.clazz = clazz;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, List<T> parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, JsonUtils.toJson(parameter));
    }

    public List<T> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.convertValue(rs.getString(columnName));
    }

    public List<T> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.convertValue(rs.getString(columnIndex));
    }

    public List<T> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.convertValue(cs.getString(columnIndex));
    }

    private List<T> convertValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        if (this.clazz != null) {
            return JsonUtils.toListObject((String)value, this.clazz);
        }
        return null;
    }
}

