/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.handler;

import com.cyberway.mp.bc.common.utils.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;

public abstract class AbstractReferenceTypeHandler<T>
extends BaseTypeHandler<T> {
    private final TypeReference<T> typeReference;

    protected AbstractReferenceTypeHandler(TypeReference<T> typeReference) {
        this.typeReference = typeReference;
    }

    public void setNonNullParameter(PreparedStatement ps, int i, T parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, JsonUtils.toJson(parameter));
    }

    public T getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.convertValue(rs.getString(columnName));
    }

    public T getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.convertValue(rs.getString(columnIndex));
    }

    public T getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.convertValue(cs.getString(columnIndex));
    }

    private T convertValue(String value) {
        if (StringUtils.isBlank((CharSequence)value)) {
            return null;
        }
        if (this.typeReference != null) {
            return (T)JsonUtils.toObject((String)value, this.typeReference);
        }
        return null;
    }
}

