/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.handler;

import com.cyberway.mp.bc.common.utils.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.springframework.util.StringUtils;

public class MapJsonTypeHandler
extends BaseTypeHandler<Map<String, Object>>
implements TypeHandler<Map<String, Object>> {
    private static final TypeReference<Map<String, Object>> MAP_TYPE_REFERENCE = new TypeReference<Map<String, Object>>(){};

    public void setNonNullParameter(PreparedStatement ps, int i, Map<String, Object> parameter, JdbcType jdbcType) throws SQLException {
        ps.setString(i, JsonUtils.toJson(parameter));
    }

    public Map<String, Object> getNullableResult(ResultSet rs, String columnName) throws SQLException {
        return this.toMap(rs.getString(columnName));
    }

    public Map<String, Object> getNullableResult(ResultSet rs, int columnIndex) throws SQLException {
        return this.toMap(rs.getString(columnIndex));
    }

    public Map<String, Object> getNullableResult(CallableStatement cs, int columnIndex) throws SQLException {
        return this.toMap(cs.getString(columnIndex));
    }

    private Map<String, Object> toMap(String str) {
        if (StringUtils.hasLength((String)str)) {
            return (Map)JsonUtils.toObject((String)str, MAP_TYPE_REFERENCE);
        }
        return new HashMap<String, Object>();
    }
}

