/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.handler;

import com.cyberway.mp.bc.dal.handler.AbstractGeometryByteTypeHandler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.CoordinateXYM;
import org.locationtech.jts.geom.CoordinateXYZM;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;

public class MssqlGeometryTypeHandler
extends AbstractGeometryByteTypeHandler {
    private static final byte HAS_Z_VALUES_MASK = 1;
    private static final byte HAS_M_VALUES_MASK = 2;
    private static final byte IS_SINGLE_POINT_MASK = 8;
    private static final byte IS_SINGLE_LINE_SEGMENT_MASK = 16;
    private static final PrecisionModel PRECISION_MODEL = new PrecisionModel(PrecisionModel.FIXED);
    private static final Map<Integer, GeometryFactory> GEOMETRY_FACTORIES = new ConcurrentHashMap<Integer, GeometryFactory>();

    @Override
    protected Geometry deserializeGeometry(byte[] bytes) throws SQLException {
        if (bytes == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        int srId = buffer.getInt();
        buffer.get();
        byte serializationProperties = buffer.get();
        boolean hasZValues = (serializationProperties & 1) != 0;
        boolean hasMValues = (serializationProperties & 2) != 0;
        boolean isSinglePoint = (serializationProperties & 8) != 0;
        boolean isSingleLineSegment = (serializationProperties & 0x10) != 0;
        Coordinate[] points = MssqlGeometryTypeHandler.readPoints(isSinglePoint, isSingleLineSegment, buffer, hasZValues, hasMValues);
        byte internalType = MssqlGeometryTypeHandler.calInternalType(isSinglePoint, isSingleLineSegment);
        GeometryFactory geometryFactory = GEOMETRY_FACTORIES.computeIfAbsent(srId, i -> new GeometryFactory(PRECISION_MODEL, i.intValue()));
        switch (internalType) {
            case 1: {
                return new Point((CoordinateSequence)new CoordinateArraySequence(points), geometryFactory);
            }
            case 2: {
                return new LineString((CoordinateSequence)new CoordinateArraySequence(points), geometryFactory);
            }
        }
        throw new SQLException("MSSQL geometry type not supported");
    }

    private static Coordinate[] readPoints(boolean isSinglePoint, boolean isSingleLineSegment, ByteBuffer buffer, boolean hasZValues, boolean hasMValues) {
        int i;
        int numberOfPoints = isSinglePoint ? 1 : (isSingleLineSegment ? 2 : buffer.getInt());
        Coordinate[] coordinates = new Coordinate[numberOfPoints];
        for (i = 0; i < numberOfPoints; ++i) {
            double xValue = buffer.getDouble();
            double yValue = buffer.getDouble();
            coordinates[i] = new Coordinate(xValue, yValue);
        }
        if (hasZValues) {
            for (i = 0; i < numberOfPoints; ++i) {
                coordinates[i].setZ(buffer.getDouble());
            }
        }
        if (hasMValues) {
            for (i = 0; i < numberOfPoints; ++i) {
                Coordinate oldCoordinate = coordinates[i];
                coordinates[i] = hasZValues ? new CoordinateXYZM(oldCoordinate.getX(), oldCoordinate.getY(), oldCoordinate.getZ(), buffer.getDouble()) : new CoordinateXYM(oldCoordinate.getX(), oldCoordinate.getY(), buffer.getDouble());
            }
        }
        return coordinates;
    }

    private static byte calInternalType(boolean isSinglePoint, boolean isSingleLineSegment) {
        byte internalType = isSinglePoint ? (byte)1 : (isSingleLineSegment ? (byte)2 : 0);
        return internalType;
    }

    @Override
    protected byte[] serializeGeometry(Geometry geometry) throws SQLException {
        ByteBuffer buffer;
        if (geometry instanceof Point) {
            buffer = MssqlGeometryTypeHandler.serializePoint(geometry);
        } else if (geometry instanceof LineString) {
            buffer = MssqlGeometryTypeHandler.serializeLineString(geometry);
        } else {
            throw new SQLException("MSSQL geometry type not supported");
        }
        return buffer.array();
    }

    private static ByteBuffer serializeLineString(Geometry geometry) {
        Coordinate[] coordinates;
        boolean hasM;
        LineString line = (LineString)geometry;
        Point startPoint = line.getStartPoint();
        Coordinate startCoordinate = startPoint.getCoordinate();
        int pointBytes = 8 * line.getNumPoints();
        int byteNum = 6 + pointBytes * 2;
        boolean hasZ = !Double.isNaN(startCoordinate.getZ());
        boolean bl = hasM = !Double.isNaN(startCoordinate.getM());
        if (hasZ) {
            byteNum += pointBytes;
        }
        if (hasM) {
            byteNum += pointBytes;
        }
        ByteBuffer buffer = ByteBuffer.allocate(byteNum).order(ByteOrder.LITTLE_ENDIAN).putInt(geometry.getSRID()).put((byte)1);
        if (hasZ && hasM) {
            buffer.put((byte)23);
        } else if (hasZ) {
            buffer.put((byte)21);
        } else if (hasM) {
            buffer.put((byte)22);
        } else {
            buffer.put((byte)20);
        }
        for (Coordinate coordinate : coordinates = line.getCoordinates()) {
            buffer.putDouble(coordinate.getX());
            buffer.putDouble(coordinate.getY());
        }
        if (hasZ) {
            for (Coordinate coordinate : coordinates) {
                buffer.putDouble(coordinate.getZ());
            }
        }
        if (hasM) {
            for (Coordinate coordinate : coordinates) {
                buffer.putDouble(coordinate.getM());
            }
        }
        return buffer;
    }

    private static ByteBuffer serializePoint(Geometry geometry) {
        boolean hasM;
        Point point = (Point)geometry;
        Coordinate coordinate = point.getCoordinate();
        int byteNum = 22;
        boolean hasZ = !Double.isNaN(coordinate.getZ());
        boolean bl = hasM = !Double.isNaN(coordinate.getM());
        if (hasZ) {
            byteNum += 8;
        }
        if (hasM) {
            byteNum += 8;
        }
        ByteBuffer buffer = ByteBuffer.allocate(byteNum).order(ByteOrder.LITTLE_ENDIAN).putInt(geometry.getSRID()).put((byte)1);
        if (hasZ && hasM) {
            buffer.put((byte)15);
        } else if (hasZ) {
            buffer.put((byte)13);
        } else if (hasM) {
            buffer.put((byte)14);
        } else {
            buffer.put((byte)12);
        }
        buffer.putDouble(point.getX());
        buffer.putDouble(point.getY());
        if (hasZ) {
            buffer.putDouble(coordinate.getZ());
        }
        if (hasM) {
            buffer.putDouble(coordinate.getM());
        }
        return buffer;
    }
}

