/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.handler;

import com.cyberway.mp.bc.dal.handler.AbstractGeometryByteTypeHandler;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MysqlGeometryTypeHandler
extends AbstractGeometryByteTypeHandler {
    private static final PrecisionModel PRECISION_MODEL = new PrecisionModel(PrecisionModel.FIXED);
    private static final Map<Integer, GeometryFactory> GEOMETRY_FACTORIES = new ConcurrentHashMap<Integer, GeometryFactory>();
    private static final Logger log = LoggerFactory.getLogger(MysqlGeometryTypeHandler.class);

    @Override
    protected Geometry deserializeGeometry(byte[] bytes) throws SQLException {
        if (bytes == null) {
            return null;
        }
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(ByteOrder.LITTLE_ENDIAN);
        int srId = buffer.getInt();
        byte[] geometryBytes = new byte[buffer.remaining()];
        buffer.get(geometryBytes);
        GeometryFactory geometryFactory = GEOMETRY_FACTORIES.computeIfAbsent(srId, i -> new GeometryFactory(PRECISION_MODEL, i.intValue()));
        WKBReader reader = new WKBReader(geometryFactory);
        try {
            return reader.read(geometryBytes);
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SQLException("00000001", "\u6570\u636e\u89e3\u6790\u5931\u8d25");
        }
    }

    @Override
    protected byte[] serializeGeometry(Geometry geometry) {
        int srId = geometry.getSRID();
        byte[] bytes = new WKBWriter(2, 2).write(geometry);
        return ByteBuffer.allocate(bytes.length + 4).order(ByteOrder.LITTLE_ENDIAN).putInt(srId).put(bytes).array();
    }
}

