/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.handler;

import com.cyberway.mp.bc.dal.handler.AbstractGeometryByteTypeHandler;
import java.sql.SQLException;
import org.apache.tomcat.util.buf.HexUtils;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.WKBWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgsqlGeometryTypeHandler
extends AbstractGeometryByteTypeHandler {
    private static final Logger log = LoggerFactory.getLogger(PgsqlGeometryTypeHandler.class);

    @Override
    protected Geometry deserializeGeometry(byte[] bytes) throws SQLException {
        WKBReader reader = new WKBReader();
        try {
            return reader.read(HexUtils.fromHexString((String)new String(bytes)));
        }
        catch (ParseException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new SQLException("00000001", "\u6570\u636e\u89e3\u6790\u5931\u8d25");
        }
    }

    @Override
    protected byte[] serializeGeometry(Geometry geometry) {
        int dimension = geometry.getDimension();
        dimension = dimension == 2 || dimension == 3 ? dimension : 2;
        WKBWriter wkbWriter = new WKBWriter(dimension, true);
        return wkbWriter.write(geometry);
    }
}

