/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.model;

import com.cyberway.mp.bc.common.api.OrderPageParam;
import com.cyberway.mp.bc.common.utils.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class OrderFragment {
    private String direction;
    private String fieldName;

    public OrderFragment(String fieldName, String direction) {
        this.fieldName = fieldName;
        this.direction = direction;
    }

    public OrderFragment() {
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String fieldName) {
        this.fieldName = fieldName;
    }

    public String getDirection() {
        return this.direction;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public static OrderFragment fromOrderPageParam(OrderPageParam orderPageParam) {
        if (StringUtils.isNotBlank((CharSequence)orderPageParam.getOrderField())) {
            OrderFragment orderFragment = new OrderFragment();
            orderFragment.setFieldName(Strings.underscoreName((String)orderPageParam.getOrderField()));
            orderFragment.setDirection((String)StringUtils.defaultIfBlank((CharSequence)orderPageParam.getOrderDirection(), (CharSequence)"ASC"));
            return orderFragment;
        }
        if (CollectionUtils.isNotEmpty((Collection)orderPageParam.getOrderList())) {
            return OrderFragment.fromOrderPageParam((OrderPageParam)orderPageParam.getOrderList().get(0));
        }
        return null;
    }

    public static List<OrderFragment> fromOrderPageParams(OrderPageParam orderPageParam) {
        OrderFragment orderFragment;
        if (StringUtils.isNotBlank((CharSequence)orderPageParam.getOrderField()) && null != (orderFragment = OrderFragment.fromOrderPageParam(orderPageParam))) {
            return List.of(orderFragment);
        }
        if (CollectionUtils.isNotEmpty((Collection)orderPageParam.getOrderList())) {
            ArrayList<OrderFragment> list = new ArrayList<OrderFragment>();
            for (OrderPageParam orderItem : orderPageParam.getOrderList()) {
                OrderFragment orderFragment2 = OrderFragment.fromOrderPageParam(orderItem);
                if (null == orderFragment2) continue;
                list.add(orderFragment2);
            }
            return list;
        }
        return null;
    }
}

