/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.util;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.dal.GenericMapper;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.core.GenericTypeResolver;

public class EntityUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(EntityUtils.class);

    private EntityUtils() {
    }

    public static List<Field> getEntityNotStaticFields(Class<?> entityClass) {
        List fields = FieldUtils.getAllFieldsList(entityClass);
        ArrayList<Field> notStaticFields = new ArrayList<Field>();
        for (Field field : fields) {
            if (Modifier.isStatic(field.getModifiers())) continue;
            notStaticFields.add(field);
        }
        return notStaticFields;
    }

    public static Class<?> getEntityClass(Class<?> mapper) {
        Class[] classes = GenericTypeResolver.resolveTypeArguments(mapper, GenericMapper.class);
        if (null != classes) {
            return classes[0];
        }
        LOGGER.error("mapper className={}", (Object)mapper.getName());
        throw new BaseException("00000001", "\u5206\u6790mapper entity\u5931\u8d25");
    }

    public static InvocationHandler resolverProxyInvocation(Object target) {
        Object currentRefObject;
        Object current = target;
        while (Proxy.isProxyClass(current.getClass()) && (currentRefObject = AopProxyUtils.getSingletonTarget((Object)current)) != null) {
            current = currentRefObject;
        }
        if (Proxy.isProxyClass(current.getClass())) {
            return Proxy.getInvocationHandler(current);
        }
        return null;
    }
}

