/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.util;

import com.cyberway.mp.bc.dal.util.RedisWorkId;
import org.springframework.beans.factory.DisposableBean;

public class IdWorker
implements DisposableBean {
    private long workerId;
    private long datacenterId;
    private long sequence;
    private long twepoch = 1619591110000L;
    private long datacenterIdBits = 3L;
    private long workerIdBits = 8L;
    private long sequenceBits = 11L;
    private long maxWorkerId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.workerIdBits;
    private long maxDatacenterId = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.datacenterIdBits;
    private long workerIdShift = this.sequenceBits;
    private long datacenterIdShift = this.sequenceBits + this.workerIdBits;
    private long timestampLeftShift = this.sequenceBits + this.workerIdBits + this.datacenterIdBits;
    private long sequenceMask = 0xFFFFFFFFFFFFFFFFL ^ -1L << (int)this.sequenceBits;
    private long lastTimestamp = -1L;
    private RedisWorkId redisWorkId;

    public IdWorker(long workerId, long datacenterId, long sequence) {
        if (workerId > this.maxWorkerId || workerId < 0L) {
            throw new IllegalArgumentException(String.format("worker Id can't be greater than %d or less than 0", this.maxWorkerId));
        }
        if (datacenterId > this.maxDatacenterId || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", this.maxDatacenterId));
        }
        this.workerId = workerId;
        this.datacenterId = datacenterId;
        this.sequence = sequence;
    }

    public IdWorker(long datacenterId, long sequence, RedisWorkId redisWorkId) {
        if (datacenterId > this.maxDatacenterId || datacenterId < 0L) {
            throw new IllegalArgumentException(String.format("datacenter Id can't be greater than %d or less than 0", this.maxDatacenterId));
        }
        this.datacenterId = datacenterId;
        this.sequence = sequence;
        this.redisWorkId = redisWorkId;
        this.workerId = redisWorkId.generateWorkId(this.maxWorkerId);
    }

    public synchronized long nextId() {
        long timestamp = this.timeGen();
        if (timestamp < this.lastTimestamp) {
            throw new IllegalCallerException(String.format("Clock moved backwards. Refusing to generate id for %d milliseconds", this.lastTimestamp - timestamp));
        }
        if (this.lastTimestamp == timestamp) {
            this.sequence = this.sequence + 1L & this.sequenceMask;
            if (this.sequence == 0L) {
                timestamp = this.tilNextMillis(this.lastTimestamp);
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = timestamp;
        return timestamp - this.twepoch << (int)this.timestampLeftShift | this.datacenterId << (int)this.datacenterIdShift | this.workerId << (int)this.workerIdShift | this.sequence;
    }

    private long tilNextMillis(long lastTimestamp) {
        long timestamp = this.timeGen();
        while (timestamp <= lastTimestamp) {
            timestamp = this.timeGen();
        }
        return timestamp;
    }

    private long timeGen() {
        return System.currentTimeMillis();
    }

    public void destroy() throws Exception {
        if (this.redisWorkId != null) {
            this.redisWorkId.destroy();
        }
    }
}

