/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.util;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class RedisWorkId {
    private static final String REDIS_USING_WORKER_ID_PREFIX = "cyberway:usingWorkerId:";
    private static final String REDIS_LAST_WORKER_ID_BEAT_PREFIX = "cyberway:lastWorkerId:";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final AtomicInteger heartBeatFailCount = new AtomicInteger(0);
    private static final int MAX_HEART_BEAT_RETRY_TIME = 3;
    private static final long HEART_BEAT_MINUTES = 10L;
    private static final long REDIS_WORKER_ID_EXPIRE_MINUTES = 30L;
    private final Long datacenterId;
    private Long workerId;
    private final ScheduledExecutorService executorService;
    private final RedisTemplate<Object, Object> template;

    public RedisWorkId(long datacenterId, RedisTemplate<Object, Object> template) {
        this.datacenterId = datacenterId;
        this.template = template;
        this.executorService = new ScheduledThreadPoolExecutor(1, r -> {
            Thread thread = new Thread(r);
            thread.setDaemon(true);
            thread.setName(RedisWorkId.class.getName() + "_redisHeatBeat");
            return thread;
        });
        this.executorService.schedule(new BeatTask(), 10L, TimeUnit.MINUTES);
    }

    public synchronized Long generateWorkId(long maxWorkerId) {
        this.workerId = (Long)this.template.boundListOps((Object)(REDIS_USING_WORKER_ID_PREFIX + this.datacenterId)).leftPop();
        if (this.workerId == null) {
            Long newId = null;
            try {
                newId = this.createNewRedisWorkerId(maxWorkerId);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
            if (newId == null) {
                throw new BaseException("00000001", "create new redis workerId failed");
            }
            this.workerId = newId;
        }
        this.logger.info("Get new redis workerId[{}]", (Object)this.workerId);
        return this.workerId;
    }

    private Long createNewRedisWorkerId(long maxWorkerId) {
        String lastWorkerIdKey = REDIS_LAST_WORKER_ID_BEAT_PREFIX + this.datacenterId;
        Object lastWorkerId = this.template.boundValueOps((Object)lastWorkerIdKey).get();
        long lastId = lastWorkerId instanceof Integer ? ((Integer)lastWorkerId).longValue() : (lastWorkerId instanceof Long ? (Long)lastWorkerId : maxWorkerId);
        for (long newId = lastId + 1L; newId != lastId; ++newId) {
            Boolean result;
            if (newId > maxWorkerId) {
                newId = 0L;
            }
            if (!Boolean.TRUE.equals(result = this.template.opsForValue().setIfAbsent((Object)this.buildUsingWorkerIdKey(newId), (Object)1, 30L, TimeUnit.MINUTES))) continue;
            this.template.opsForValue().set((Object)lastWorkerIdKey, (Object)newId);
            this.heartBeatFailCount.set(0);
            return newId;
        }
        this.logger.warn("Not enough workerId");
        return null;
    }

    private String buildUsingWorkerIdKey(Long usingWorkerId) {
        return REDIS_USING_WORKER_ID_PREFIX + this.datacenterId + ":" + usingWorkerId;
    }

    public void destroy() {
        this.logger.info("RedisWorkId destroy");
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
        this.returnOldWorkerId(this.workerId);
    }

    private void returnOldWorkerId(Long oldWorkerId) {
        if (oldWorkerId != null) {
            try {
                this.template.boundListOps((Object)(REDIS_USING_WORKER_ID_PREFIX + this.datacenterId)).rightPush((Object)oldWorkerId);
                this.template.delete((Object)this.buildUsingWorkerIdKey(oldWorkerId));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    class BeatTask
    implements Runnable {
        BeatTask() {
        }

        @Override
        public void run() {
            block8: {
                if (RedisWorkId.this.workerId != null) {
                    try {
                        Boolean expire = RedisWorkId.this.template.expire((Object)RedisWorkId.this.buildUsingWorkerIdKey(RedisWorkId.this.workerId), 30L, TimeUnit.MINUTES);
                        if (Boolean.TRUE.equals(expire)) {
                            RedisWorkId.this.heartBeatFailCount.set(0);
                        } else {
                            RedisWorkId.this.workerId = null;
                        }
                    }
                    catch (Exception e) {
                        RedisWorkId.this.logger.error(e.getMessage(), (Throwable)e);
                        if (RedisWorkId.this.heartBeatFailCount.incrementAndGet() < 3) break block8;
                        RedisWorkId.this.workerId = null;
                        RedisWorkId.this.heartBeatFailCount.set(0);
                    }
                }
            }
            if (RedisWorkId.this.executorService != null) {
                try {
                    RedisWorkId.this.executorService.schedule(new BeatTask(), 10L, TimeUnit.MINUTES);
                }
                catch (Exception e) {
                    RedisWorkId.this.logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

