/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.dal.util;

import com.cyberway.mp.bc.dal.config.DALProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SqlEscape {
    private static final String COMMA = ".";
    @Autowired
    private DALProperties dalProperties;

    public void setDalProperties(DALProperties dalProperties) {
        this.dalProperties = dalProperties;
    }

    public DALProperties getDalProperties() {
        return this.dalProperties;
    }

    public String escapeColName(String colName) {
        return this.escapeColName(colName, false);
    }

    public String escapeColName(String colName, boolean ignoreCaseConvert) {
        if (colName.startsWith(this.startEscapeChar())) {
            return colName;
        }
        if (colName.contains(COMMA)) {
            String[] split = colName.split("\\.");
            if (split[1].startsWith(this.startEscapeChar())) {
                return colName;
            }
            return split[0] + COMMA + this.escapeColNameInter(split[1], ignoreCaseConvert);
        }
        return this.escapeColNameInter(colName, ignoreCaseConvert);
    }

    private String startEscapeChar() {
        if (this.dalProperties.currentDialectIsSqlServer()) {
            return "[";
        }
        if (this.dalProperties.currentDialectIsMysql()) {
            return "`";
        }
        return "\"";
    }

    private String escapeColNameInter(String colName, boolean ignoreCaseConvert) {
        if (!ignoreCaseConvert) {
            switch (this.dalProperties.getColCaseType()) {
                case 1: {
                    colName = colName.toUpperCase();
                    break;
                }
                case 2: {
                    colName = colName.toLowerCase();
                    break;
                }
            }
        }
        if (this.dalProperties.currentDialectIsSqlServer()) {
            return "[" + colName + "]";
        }
        if (this.dalProperties.currentDialectIsMysql()) {
            return "`" + colName + "`";
        }
        if (this.dalProperties.currentDialectIsH2()) {
            return colName;
        }
        return "\"" + colName + "\"";
    }
}

