/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.es.dal;

import com.cyberway.mp.bc.es.dal.RepositoryInvocationHandler;
import com.cyberway.mp.bc.es.dal.genarate.GeneratorFactory;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.WildcardType;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.FactoryBean;

public class ElasticSearchRepositoryFactoryBean
implements FactoryBean<Object>,
BeanFactoryAware {
    private final Logger logger = LoggerFactory.getLogger(ElasticSearchRepositoryFactoryBean.class);
    private Class<?> type;
    private Class<?> documentClazz;
    private Class<?> primaryKeyClazz;
    private String beanName;
    private BeanFactory beanFactory;

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public Object getObject() {
        if (!this.type.isInterface()) {
            throw new IllegalArgumentException("Type must be an interface: " + this.type);
        }
        for (Method m : this.type.getMethods()) {
            Class<?> retType = m.getReturnType();
            if (!CompletableFuture.class.isAssignableFrom(retType)) continue;
            if (retType != CompletableFuture.class) {
                throw new IllegalArgumentException("Method return type is not CompleteableFuture: " + this.getFullMethodName(this.type, retType, m));
            }
            Type genRetType = m.getGenericReturnType();
            if (!(genRetType instanceof ParameterizedType)) {
                throw new IllegalArgumentException("Method return type is not parameterized: " + this.getFullMethodName(this.type, genRetType, m));
            }
            if (!(((ParameterizedType)genRetType).getActualTypeArguments()[0] instanceof WildcardType)) continue;
            throw new IllegalArgumentException("Wildcards are not supported for return-type parameters: " + this.getFullMethodName(this.type, genRetType, m));
        }
        GeneratorFactory generatorFactory = null;
        try {
            generatorFactory = (GeneratorFactory)this.beanFactory.getBean(GeneratorFactory.class);
        }
        catch (BeansException e) {
            this.logger.error("getObject error", (Throwable)e);
        }
        if (null == generatorFactory) {
            throw new IllegalArgumentException("require bean com.cyberway.mp.bc.es.dal.genarate.GeneratorFactory");
        }
        return this.type.cast(Proxy.newProxyInstance(this.type.getClassLoader(), new Class[]{this.type}, new RepositoryInvocationHandler(this.type, this.documentClazz, this.primaryKeyClazz, generatorFactory)));
    }

    private String getFullMethodName(Class<?> type, Type retType, Method m) {
        return retType.getTypeName() + " " + type.toGenericString() + "." + m.getName();
    }

    public Class<?> getObjectType() {
        return this.type;
    }

    public void setType(Class<?> type) {
        this.type = type;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setDocumentClazz(Class<?> documentClazz) {
        this.documentClazz = documentClazz;
    }

    public void setPrimaryKeyClazz(Class<?> primaryKeyClazz) {
        this.primaryKeyClazz = primaryKeyClazz;
    }
}

