/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.es.dal;

import co.elastic.clients.elasticsearch._types.RequestBase;
import com.cyberway.mp.bc.es.dal.genarate.GeneratorFactory;
import com.cyberway.mp.bc.es.dal.genarate.RequestGenerator;
import com.cyberway.mp.bc.es.dal.genarate.ResponseGenerator;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryInvocationHandler<T, D, PK>
implements InvocationHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Class<T> type;
    private final Class<D> documentClazz;
    private final Class<PK> primaryKeyClass;
    private final GeneratorFactory generatorFactory;

    public RepositoryInvocationHandler(Class<T> type, Class<D> documentClazz, Class<PK> primaryKeyClass, GeneratorFactory generatorFactory) {
        this.type = type;
        this.documentClazz = documentClazz;
        this.primaryKeyClass = primaryKeyClass;
        this.generatorFactory = generatorFactory;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if ("equals".equals(method.getName()) && method.getParameterCount() == 1) {
            try {
                InvocationHandler otherHandler = args.length > 0 && args[0] != null ? Proxy.getInvocationHandler(args[0]) : null;
                return this.equals(otherHandler);
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        if ("hashCode".equals(method.getName()) && method.getParameterCount() == 0) {
            return this.hashCode();
        }
        if ("toString".equals(method.getName()) && method.getParameterCount() == 0) {
            return this.toString();
        }
        RequestGenerator requestGenerator = this.generatorFactory.findRequestGenerator(method);
        RequestBase requestBase = requestGenerator.generate(method, this.documentClazz, this.primaryKeyClass, args);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(requestBase.toString());
        }
        ResponseGenerator responseGenerator = this.generatorFactory.findResponseGenerator(requestBase);
        return responseGenerator.generate(method, this.documentClazz, this.primaryKeyClass, args, requestBase);
    }

    public Class<T> getType() {
        return this.type;
    }
}

