/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.es.dal.config;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch.indices.ElasticsearchIndicesClient;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import co.elastic.clients.transport.ElasticsearchTransport;
import co.elastic.clients.transport.rest_client.RestClientTransport;
import com.cyberway.mp.bc.es.dal.config.ElasticSearchProperties;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import java.net.URI;
import java.util.stream.Collectors;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.nio.client.HttpAsyncClientBuilder;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.StringUtils;

@Configuration(proxyBeanMethods=false)
@EnableConfigurationProperties(value={ElasticSearchProperties.class})
public class ElasticsearchClientAutoConfiguration {
    private final ElasticSearchProperties properties;

    public ElasticsearchClientAutoConfiguration(ElasticSearchProperties properties) {
        this.properties = properties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ElasticsearchClient elasticsearchClient(JacksonJsonpMapper jacksonJsonpMapper) {
        RestClientBuilder restClientBuilder = this.getRestClientBuilder();
        RestClientTransport transport = new RestClientTransport(restClientBuilder.build(), (JsonpMapper)jacksonJsonpMapper);
        return new ElasticsearchClient((ElasticsearchTransport)transport);
    }

    @Bean
    @ConditionalOnMissingBean
    public ElasticsearchIndicesClient elasticsearchIndicesClient(JacksonJsonpMapper jacksonJsonpMapper) {
        RestClientBuilder restClientBuilder = this.getRestClientBuilder();
        RestClientTransport transport = new RestClientTransport(restClientBuilder.build(), (JsonpMapper)jacksonJsonpMapper);
        return new ElasticsearchIndicesClient((ElasticsearchTransport)transport);
    }

    private RestClientBuilder getRestClientBuilder() {
        RestClientBuilder restClientBuilder = RestClient.builder((HttpHost[])this.buildHttpHosts());
        RestClientBuilder.RequestConfigCallback requestConfigCallback = builder -> {
            builder.setConnectTimeout(this.properties.getConnectionTimeout().toMillisPart()).setSocketTimeout(this.properties.getSocketTimeout().toMillisPart());
            return builder;
        };
        restClientBuilder.setRequestConfigCallback(requestConfigCallback);
        if (StringUtils.hasLength((String)this.properties.getUsername()) && StringUtils.hasLength((String)this.properties.getPassword())) {
            BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
            credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(this.properties.getUsername(), this.properties.getPassword()));
            restClientBuilder.setHttpClientConfigCallback(arg_0 -> ElasticsearchClientAutoConfiguration.lambda$getRestClientBuilder$1((CredentialsProvider)credentialsProvider, arg_0));
        }
        return restClientBuilder;
    }

    @Bean
    @ConditionalOnMissingBean
    public JacksonJsonpMapper jacksonJsonpMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return new JacksonJsonpMapper(objectMapper);
    }

    private HttpHost[] buildHttpHosts() {
        return this.properties.getUris().stream().map(s -> s.startsWith("http") ? s : "http://" + s).map(URI::create).map(uri -> new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme())).collect(Collectors.toList()).toArray(new HttpHost[0]);
    }

    private static /* synthetic */ HttpAsyncClientBuilder lambda$getRestClientBuilder$1(CredentialsProvider credentialsProvider, HttpAsyncClientBuilder httpClientBuilder) {
        return httpClientBuilder.setDefaultCredentialsProvider(credentialsProvider);
    }
}

