/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.es.dal.genarate;

import co.elastic.clients.elasticsearch._types.RequestBase;
import com.cyberway.mp.bc.es.dal.genarate.RequestGenerator;
import com.cyberway.mp.bc.es.dal.genarate.ResponseGenerator;
import java.lang.reflect.Method;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class GeneratorFactory {
    private List<RequestGenerator> requestGeneratorList;
    private List<ResponseGenerator> responseGeneratorList;

    public List<RequestGenerator> getRequestGeneratorList() {
        return this.requestGeneratorList;
    }

    public void setRequestGeneratorList(List<RequestGenerator> requestGeneratorList) {
        this.requestGeneratorList = requestGeneratorList;
    }

    public List<ResponseGenerator> getResponseGeneratorList() {
        return this.responseGeneratorList;
    }

    public void setResponseGeneratorList(List<ResponseGenerator> responseGeneratorList) {
        this.responseGeneratorList = responseGeneratorList;
    }

    public ResponseGenerator findResponseGenerator(RequestBase requestBase) {
        if (CollectionUtils.isEmpty(this.responseGeneratorList)) {
            throw new IllegalArgumentException("responseGeneratorList is empty");
        }
        for (ResponseGenerator responseGenerator : this.responseGeneratorList) {
            if (!responseGenerator.match(requestBase)) continue;
            return responseGenerator;
        }
        throw new UnsupportedOperationException("missing ResponseGenerator for request:" + requestBase);
    }

    public RequestGenerator findRequestGenerator(Method method) {
        if (CollectionUtils.isEmpty(this.requestGeneratorList)) {
            throw new IllegalArgumentException("requestGeneratorList is empty");
        }
        for (RequestGenerator requestGenerator : this.requestGeneratorList) {
            if (!requestGenerator.match(method)) continue;
            return requestGenerator;
        }
        throw new UnsupportedOperationException("missing RequestGenerator for method:" + method.getName());
    }
}

