/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.es.dal.genarate.parser;

import co.elastic.clients.elasticsearch.core.search.Highlight;
import co.elastic.clients.elasticsearch.core.search.HighlightField;
import co.elastic.clients.elasticsearch.core.search.HighlighterOrder;
import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.annotation.Alias;
import com.cyberway.mp.bc.es.dal.annotation.query.Highlight;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.util.Collection;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.CollectionUtils;

public class HighlightSource {
    private final Highlight.Builder builder = new Highlight.Builder();

    public void addHighlights(Collection<Field> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return;
        }
        fields.forEach(this::addHighlight);
    }

    public void addHighlight(Field field) {
        if (null == field) {
            return;
        }
        Highlight highlight = field.getAnnotation(Highlight.class);
        if (null == highlight) {
            return;
        }
        Alias alias = (Alias)AnnotationUtils.getAnnotation((AnnotatedElement)field, Alias.class);
        String aliasName = alias == null || StringUtils.isBlank((CharSequence)alias.name()) ? null : alias.name();
        String esFieldName = StringUtils.isNotBlank(aliasName) ? aliasName : Strings.underscoreName((String)field.getName());
        HighlightField.Builder fieldBuilder = new HighlightField.Builder();
        if (StringUtils.isNotBlank((CharSequence)highlight.preTag())) {
            fieldBuilder.preTags(highlight.preTag(), new String[0]);
        }
        if (StringUtils.isNotBlank((CharSequence)highlight.postTag())) {
            fieldBuilder.postTags(highlight.postTag(), new String[0]);
        }
        if (highlight.fragmentSize() > 0) {
            fieldBuilder.fragmentSize(Integer.valueOf(highlight.fragmentSize()));
        }
        if (highlight.numberOfFragments() > 0) {
            fieldBuilder.numberOfFragments(Integer.valueOf(highlight.numberOfFragments()));
        }
        this.builder.fields(esFieldName, fieldBuilder.build());
    }

    public co.elastic.clients.elasticsearch.core.search.Highlight toHighlight() {
        this.builder.order(HighlighterOrder.Score);
        return this.builder.build();
    }
}

