/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.es.dal.genarate.parser;

import co.elastic.clients.elasticsearch._types.FieldSort;
import co.elastic.clients.elasticsearch._types.SortOptions;
import co.elastic.clients.elasticsearch._types.SortOrder;
import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.annotation.query.OrderByField;
import com.cyberway.mp.bc.es.dal.genarate.parser.Direction;
import com.cyberway.mp.bc.es.dal.genarate.parser.Order;
import com.cyberway.mp.bc.es.dal.model.OrderField;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class OrderBySource {
    public static final OrderBySource EMPTY = new OrderBySource("");
    private static final String BLOCK_SPLIT = "(?<=Asc|Desc)(?=\\p{Lu})";
    private static final Pattern DIRECTION_SPLIT = Pattern.compile("(.+?)(Asc|Desc)?$");
    private static final String INVALID_ORDER_SYNTAX = "Invalid order syntax for part %s!";
    private static final Set<String> DIRECTION_KEYWORDS = new HashSet<String>(Arrays.asList("Asc", "Desc"));
    private static final Logger log = LoggerFactory.getLogger(OrderBySource.class);
    private final List<Order> orders = new ArrayList<Order>();

    public OrderBySource(String clause) {
        if (!StringUtils.hasText((String)clause)) {
            return;
        }
        for (String part : clause.split(BLOCK_SPLIT)) {
            Matcher matcher = DIRECTION_SPLIT.matcher(part);
            if (!matcher.find()) {
                throw new IllegalArgumentException(String.format(INVALID_ORDER_SYNTAX, part));
            }
            String propertyString = matcher.group(1);
            String directionString = matcher.group(2);
            if (DIRECTION_KEYWORDS.contains(propertyString) && directionString == null) {
                throw new IllegalArgumentException(String.format(INVALID_ORDER_SYNTAX, part));
            }
            this.orders.add(this.createOrder(Strings.underscoreName((String)propertyString), Direction.fromString(directionString)));
        }
    }

    public OrderBySource(Object queryBean, List<Field> fields) {
        for (Field field : fields) {
            OrderByField orderByField = field.getAnnotation(OrderByField.class);
            if (orderByField == null) continue;
            this.handleOrderByField(field, queryBean, orderByField);
        }
    }

    private void handleOrderByField(Field field, Object queryBean, OrderByField orderByField) {
        Object fieldObjectInstance;
        try {
            field.setAccessible(true);
            fieldObjectInstance = field.get(queryBean);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new BaseException("00000001", String.format("get order field value error\uff1a '%s' .", field.getName()));
        }
        int order = orderByField.order();
        if (fieldObjectInstance != null) {
            if (fieldObjectInstance instanceof OrderField) {
                this.handleOrderField(order, fieldObjectInstance);
            } else if (fieldObjectInstance instanceof String) {
                Direction direction = Direction.fromString(fieldObjectInstance.toString());
                this.orders.add(new Order(direction, Strings.underscoreName((String)field.getName()), order));
            } else if (fieldObjectInstance instanceof Collection) {
                Collection orderFragments = (Collection)fieldObjectInstance;
                for (Object eachFieldObject : orderFragments) {
                    if (!(eachFieldObject instanceof OrderField)) continue;
                    this.handleOrderField(order, eachFieldObject);
                }
            }
        }
    }

    private void handleOrderField(int order, Object fieldObjectInstance) {
        OrderField orderField = (OrderField)fieldObjectInstance;
        Direction direction = Direction.fromString(orderField.getDirection());
        this.orders.add(new Order(direction, orderField.getFieldName(), order));
    }

    private Order createOrder(String propertySource, Direction direction) {
        return new Order(direction, propertySource);
    }

    public List<SortOptions> toSortOptions() {
        if (CollectionUtils.isEmpty(this.orders)) {
            return Collections.emptyList();
        }
        return this.orders.stream().map(order -> SortOptions.of(sortOptionsBuilder -> sortOptionsBuilder.field(FieldSort.of(fieldSortBuilder -> fieldSortBuilder.field(order.getProperty()).order(order.getDirection() == Direction.ASC ? SortOrder.Asc : SortOrder.Desc))))).collect(Collectors.toList());
    }
}

