/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.es.dal.genarate.parser;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.cyberway.mp.bc.common.utils.Strings;
import com.cyberway.mp.bc.dal.annotation.Alias;
import com.cyberway.mp.bc.dal.annotation.query.Not;
import com.cyberway.mp.bc.es.dal.annotation.query.ElasticSearchQueryBean;
import com.cyberway.mp.bc.es.dal.genarate.QueryGenerator;
import com.cyberway.mp.bc.es.dal.genarate.parser.Predicate;
import com.cyberway.mp.bc.es.dal.genarate.parser.PropertyType;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

public class Part
extends QueryGenerator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private PropertyType type;
    private final String property;
    private final String esFieldName;
    private final Field field;
    private final Predicate nestedPredicate;
    private final Boolean isFromQueryBean;

    public Part(String source) {
        this.type = PropertyType.fromProperty(source);
        this.property = this.type.extractProperty(source);
        this.esFieldName = Strings.underscoreName((String)this.property);
        this.field = null;
        this.nestedPredicate = null;
        this.isFromQueryBean = false;
    }

    public Part(Object queryBean, Field field) {
        this.field = field;
        if (field.isAnnotationPresent(ElasticSearchQueryBean.class) || field.getType().isAnnotationPresent(ElasticSearchQueryBean.class)) {
            this.property = field.getName();
            this.esFieldName = null;
            Object nestedQueryBean = null;
            try {
                nestedQueryBean = FieldUtils.readField((Object)queryBean, (String)field.getName(), (boolean)true);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException("read field : [" + field.getName() + "] error");
            }
            this.nestedPredicate = new Predicate(nestedQueryBean, field.getType(), true);
            this.type = field.isAnnotationPresent(Not.class) ? PropertyType.NESTED_NOT : PropertyType.NESTED_AND;
        } else {
            Annotation[] fieldAnnotations;
            this.nestedPredicate = null;
            String alias = "";
            for (Annotation annotation : fieldAnnotations = field.getAnnotations()) {
                PropertyType propertyType;
                if (annotation instanceof Alias && StringUtils.isNotBlank((CharSequence)((Alias)annotation).name())) {
                    alias = ((Alias)annotation).name();
                }
                if ((propertyType = PropertyType.fromAnnotation(annotation, field.isAnnotationPresent(Not.class))) == null) continue;
                this.type = propertyType;
            }
            if (this.type == null) {
                this.type = PropertyType.SIMPLE_PROPERTY;
            }
            this.property = field.getName();
            this.esFieldName = StringUtils.isNotBlank((CharSequence)alias) ? alias : Strings.underscoreName((String)this.property);
        }
        this.isFromQueryBean = true;
    }

    public PropertyType getType() {
        return this.type;
    }

    public String getProperty() {
        return this.property;
    }

    public String getEsFieldName() {
        return this.esFieldName;
    }

    @Override
    public Query generate(Method method, Field conditionFiled, Object[] args, Part part) {
        if (args.length < part.getType().getNumberOfArguments()) {
            throw new IllegalArgumentException("missing parameter from property:" + this.property + ". require args size:" + part.getType().getNumberOfArguments());
        }
        if (Boolean.TRUE.equals(this.isFromQueryBean)) {
            args = this.getArgsFormQueryBean(part, args[0]);
        }
        if (part.getType() != PropertyType.NESTED_AND && part.getType() != PropertyType.NESTED_NOT) {
            try {
                QueryGenerator queryGenerator = part.getType().getQueryGeneratorClazz().getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                return queryGenerator.generate(method, conditionFiled, args, part);
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
                throw new IllegalArgumentException(part.getType().name() + " install QueryGenerator error");
            }
        }
        return this.getNestedQuery(method, args[0]);
    }

    private Query getNestedQuery(Method method, Object nestedQueryBean) {
        return this.nestedPredicate.generate(method, new Object[]{nestedQueryBean});
    }

    private Object[] getArgsFormQueryBean(Part part, Object queryBean) {
        Assert.notNull((Object)part, (String)"part not allow null");
        Assert.notNull((Object)queryBean, (String)"queryBean not allow null");
        PropertyType propertyType = part.getType();
        int numberOfArguments = propertyType.getNumberOfArguments();
        ArrayList<Object> queryArgs = new ArrayList<Object>(numberOfArguments);
        if (numberOfArguments > 0) {
            try {
                queryArgs.add(FieldUtils.readField((Object)queryBean, (String)part.getProperty(), (boolean)true));
            }
            catch (Exception e) {
                this.logger.error(e.getMessage(), (Throwable)e);
            }
        }
        return queryArgs.toArray(new Object[0]);
    }

    @Override
    public Query generate(Method method, Object[] args) {
        return this.generate(method, this.field, args, this);
    }
}

