/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.es.dal.genarate.parser;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import com.cyberway.mp.bc.dal.annotation.Or;
import com.cyberway.mp.bc.dal.annotation.query.IgnoreField;
import com.cyberway.mp.bc.dal.annotation.query.OrderByField;
import com.cyberway.mp.bc.es.dal.annotation.query.Highlight;
import com.cyberway.mp.bc.es.dal.genarate.QueryGenerator;
import com.cyberway.mp.bc.es.dal.genarate.parser.HighlightSource;
import com.cyberway.mp.bc.es.dal.genarate.parser.OrPart;
import com.cyberway.mp.bc.es.dal.genarate.parser.OrPartParser;
import com.cyberway.mp.bc.es.dal.genarate.parser.OrderBySource;
import com.cyberway.mp.bc.es.dal.genarate.parser.Part;
import com.cyberway.mp.bc.es.dal.utils.EntityUtil;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.CollectionUtils;

public class Predicate
extends QueryGenerator {
    private static final String ORDER_BY = "OrderBy";
    private final List<OrPart> orPartNodes;
    private final List<Part> andPartNodes;
    private final OrderBySource orderBySource;
    private final HighlightSource highlightSource;

    public Predicate(String predicate) {
        String[] parts = StringUtils.splitByWholeSeparator((String)predicate, (String)ORDER_BY);
        if (parts.length > 2) {
            throw new IllegalArgumentException("OrderBy must not be used more than once in a method name!");
        }
        OrPartParser orPartParser = new OrPartParser(parts[0]);
        this.orPartNodes = orPartParser.parse();
        this.andPartNodes = Collections.emptyList();
        this.orderBySource = parts.length == 2 ? new OrderBySource(parts[1]) : OrderBySource.EMPTY;
        this.highlightSource = null;
    }

    public Predicate(Object queryBean, Class<?> queryBeanClass, boolean isNested) {
        List<Field> fields = EntityUtil.getEntityNotStaticAndNotNullFields(queryBean, queryBeanClass);
        this.orPartNodes = this.buildOrPartNodes(queryBean, fields);
        this.andPartNodes = this.buildAndPartNodes(queryBean, fields);
        if (isNested) {
            this.orderBySource = OrderBySource.EMPTY;
            this.highlightSource = null;
        } else {
            this.orderBySource = this.buildOrderBySource(queryBean, fields);
            this.highlightSource = this.buildHighlight(queryBean);
        }
    }

    private HighlightSource buildHighlight(Object queryBean) {
        if (null == queryBean) {
            return null;
        }
        List<Field> fields = EntityUtil.getEntityNotStaticFields(queryBean.getClass()).stream().filter(f -> f.isAnnotationPresent(Highlight.class)).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(fields)) {
            HighlightSource source = new HighlightSource();
            source.addHighlights(fields);
            return source;
        }
        return null;
    }

    private OrderBySource buildOrderBySource(Object queryBean, List<Field> fields) {
        if (CollectionUtils.isEmpty(fields) || null == queryBean) {
            return OrderBySource.EMPTY;
        }
        return new OrderBySource(queryBean, fields);
    }

    private List<Part> buildAndPartNodes(Object queryBean, List<Field> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return Collections.emptyList();
        }
        return fields.stream().filter(f -> !f.isAnnotationPresent(IgnoreField.class)).filter(f -> !f.isAnnotationPresent(Or.class)).filter(f -> !f.isAnnotationPresent(OrderByField.class)).map(f -> new Part(queryBean, (Field)f)).collect(Collectors.toList());
    }

    private List<OrPart> buildOrPartNodes(Object queryBean, List<Field> fields) {
        if (CollectionUtils.isEmpty(fields)) {
            return Collections.emptyList();
        }
        return fields.stream().filter(f -> !f.isAnnotationPresent(IgnoreField.class)).filter(f -> f.isAnnotationPresent(Or.class)).map(f -> new OrPart(queryBean, (Field)f)).collect(Collectors.toList());
    }

    public List<OrPart> getOrPartNodes() {
        return this.orPartNodes;
    }

    public OrderBySource getOrderBySource() {
        return this.orderBySource;
    }

    public HighlightSource getHighlightSource() {
        return this.highlightSource;
    }

    @Override
    public Query generate(Method method, Field conditionFiled, Object[] args, Part part) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Query generate(Method method, Object[] args) {
        BoolQuery.Builder boolBuilder = new BoolQuery.Builder();
        if (!CollectionUtils.isEmpty(this.orPartNodes)) {
            boolBuilder.should(this.orPartNodes.stream().map(orPart -> orPart.generate(method, args)).collect(Collectors.toList()));
        }
        if (!CollectionUtils.isEmpty(this.andPartNodes)) {
            for (Part andPart : this.andPartNodes) {
                Query query = andPart.generate(method, args);
                this.boolQueryBuild(boolBuilder, query, andPart.getType());
            }
        }
        return boolBuilder.build()._toQuery();
    }
}

