/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.es.dal.genarate.parser;

import com.cyberway.mp.bc.es.dal.genarate.QueryGenerator;
import com.cyberway.mp.bc.es.dal.genarate.query.ExistsQueryGenerator;
import com.cyberway.mp.bc.es.dal.genarate.query.QueryStringQueryGenerator;
import com.cyberway.mp.bc.es.dal.genarate.query.RangeQueryGenerator;
import com.cyberway.mp.bc.es.dal.genarate.query.TermQueryGenerator;
import com.cyberway.mp.bc.es.dal.genarate.query.TermsQueryGenerator;
import com.cyberway.mp.bc.es.dal.genarate.query.WildCardQueryGenerator;
import java.beans.Introspector;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.StringUtils;

public enum PropertyType {
    BETWEEN(2, RangeQueryGenerator.class, "Between"),
    LESS_THAN(1, RangeQueryGenerator.class, "LessThan"),
    LESS_THAN_EQUAL(1, RangeQueryGenerator.class, "LessThanEqual"),
    GREATER_THAN(1, RangeQueryGenerator.class, "GreaterThan"),
    GREATER_THAN_EQUAL(1, RangeQueryGenerator.class, "GreaterThanEqual"),
    BEFORE(1, RangeQueryGenerator.class, "Before"),
    AFTER(1, RangeQueryGenerator.class, "After"),
    IS_NOT_NULL(0, ExistsQueryGenerator.class, "IsNotNull", "NotNull"),
    IS_NULL(false, 0, ExistsQueryGenerator.class, "IsNull", "Null"),
    NOT_LIKE(false, 1, WildCardQueryGenerator.class, "NotLike"),
    LIKE(1, WildCardQueryGenerator.class, "Like"),
    STARTING_WITH(1, WildCardQueryGenerator.class, "StartsWith"),
    ENDING_WITH(1, WildCardQueryGenerator.class, "EndsWith"),
    NOT_CONTAINING(false, 1, WildCardQueryGenerator.class, "NotContains"),
    CONTAINING(1, WildCardQueryGenerator.class, "Contains"),
    NOT_IN(false, 1, TermsQueryGenerator.class, "NotIn"),
    IN(1, TermsQueryGenerator.class, "In"),
    TRUE(0, TermQueryGenerator.class, "True"),
    FALSE(0, TermQueryGenerator.class, "False"),
    NEGATING_SIMPLE_PROPERTY(false, 1, TermQueryGenerator.class, "Not"),
    SIMPLE_PROPERTY(1, TermQueryGenerator.class, "Equals"),
    FULL_TEXT_QUERY(1, QueryStringQueryGenerator.class, "FullTextQuery"),
    FULL_TEXT_QUERY_NOT(false, 1, QueryStringQueryGenerator.class, "FullTextQuery"),
    NESTED_AND(1, null, ""),
    NESTED_NOT(false, 1, null, "");

    public static final String FULL_TEXT_QUERY_KEYWORD = "FullTextQuery";
    private final List<String> keywords;
    private final int numberOfArguments;
    private final Boolean mustFlag;
    private final Class<? extends QueryGenerator> queryGeneratorClazz;

    private PropertyType(int numberOfArguments, Class<? extends QueryGenerator> queryGeneratorClazz, String ... keywords) {
        this(true, numberOfArguments, queryGeneratorClazz, keywords);
    }

    private PropertyType(boolean mustFlag, int numberOfArguments, Class<? extends QueryGenerator> queryGeneratorClazz, String ... keywords) {
        this.mustFlag = mustFlag;
        this.numberOfArguments = numberOfArguments;
        this.queryGeneratorClazz = queryGeneratorClazz;
        this.keywords = Arrays.asList(keywords);
    }

    public static PropertyType fromProperty(String rawProperty) {
        for (PropertyType type : PropertyType.values()) {
            if (!type.supports(rawProperty)) continue;
            return type;
        }
        return SIMPLE_PROPERTY;
    }

    public static PropertyType fromAnnotation(Annotation annotation, boolean isNot) {
        String annotationName = annotation.annotationType().getSimpleName();
        if (FULL_TEXT_QUERY_KEYWORD.equals(annotationName)) {
            return isNot ? FULL_TEXT_QUERY_NOT : FULL_TEXT_QUERY;
        }
        for (PropertyType type : PropertyType.values()) {
            if (!type.hasKeyWord(annotationName)) continue;
            return type;
        }
        return null;
    }

    protected boolean hasKeyWord(String sqlKeyWord) {
        for (String keyword : this.keywords) {
            if (!sqlKeyWord.equalsIgnoreCase(keyword)) continue;
            return true;
        }
        return false;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public int getNumberOfArguments() {
        return this.numberOfArguments;
    }

    public Boolean getMustFlag() {
        return this.mustFlag;
    }

    protected boolean supports(String property) {
        for (String keyword : this.keywords) {
            if (!StringUtils.hasText((String)keyword) || !property.endsWith(keyword)) continue;
            return true;
        }
        return false;
    }

    public String extractProperty(String source) {
        String candidate = Introspector.decapitalize(source);
        for (String keyword : this.keywords) {
            if (!candidate.endsWith(keyword)) continue;
            return candidate.substring(0, candidate.length() - keyword.length());
        }
        return candidate;
    }

    public Class<? extends QueryGenerator> getQueryGeneratorClazz() {
        return this.queryGeneratorClazz;
    }
}

