/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.es.dal.genarate.query;

import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.RangeQuery;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.json.jackson.JacksonJsonpMapper;
import com.cyberway.mp.bc.es.dal.annotation.query.Boost;
import com.cyberway.mp.bc.es.dal.annotation.query.DateFormat;
import com.cyberway.mp.bc.es.dal.genarate.QueryGenerator;
import com.cyberway.mp.bc.es.dal.genarate.parser.Part;
import com.cyberway.mp.bc.es.dal.genarate.parser.PropertyType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategies;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.TimeZone;
import org.apache.commons.lang3.time.DateFormatUtils;

public class RangeQueryGenerator
extends QueryGenerator {
    public JacksonJsonpMapper jacksonJsonpMapper() {
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setPropertyNamingStrategy(PropertyNamingStrategies.SNAKE_CASE);
        return new JacksonJsonpMapper(objectMapper);
    }

    @Override
    public Query generate(Method method, Field conditionFiled, Object[] args, Part part) {
        Boost boost;
        if (part.getType() == PropertyType.BETWEEN && (null == args[0] || null == args[1])) {
            return null;
        }
        if (null == args[0]) {
            return null;
        }
        RangeQuery.Builder builder = new RangeQuery.Builder();
        builder.field(part.getEsFieldName());
        if (null != conditionFiled && null != (boost = conditionFiled.getAnnotation(Boost.class))) {
            builder.boost(Float.valueOf(boost.score()));
        }
        args = this.handleArgs(method, conditionFiled, args);
        switch (part.getType()) {
            case BETWEEN: {
                builder.gte(JsonData.of((Object)args[0]));
                builder.lte(JsonData.of((Object)args[1]));
                break;
            }
            case LESS_THAN: 
            case BEFORE: {
                builder.lt(JsonData.of((Object)args[0]));
                break;
            }
            case LESS_THAN_EQUAL: {
                builder.lte(JsonData.of((Object)args[0]));
                break;
            }
            case GREATER_THAN: 
            case AFTER: {
                builder.gt(JsonData.of((Object)args[0]));
                break;
            }
            case GREATER_THAN_EQUAL: {
                builder.gte(JsonData.of((Object)args[0]));
                break;
            }
            default: {
                throw new UnsupportedOperationException("RangeQueryGenerator not support propertyType:" + part.getType().name());
            }
        }
        return builder.build()._toQuery();
    }

    private Object[] handleArgs(Method method, Field conditionFiled, Object[] args) {
        if (null == args || args.length == 0) {
            return args;
        }
        Object[] result = new Object[args.length];
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            if (arg instanceof Date) {
                arg = this.handleDate(method, conditionFiled, (Date)arg);
            }
            result[i] = arg;
        }
        return result;
    }

    private Object handleDate(Method method, Field conditionFiled, Date date) {
        DateFormat dateFormat = method.getAnnotation(DateFormat.class);
        if (null == dateFormat) {
            if (null != conditionFiled) {
                dateFormat = conditionFiled.getAnnotation(DateFormat.class);
            }
            if (null == dateFormat) {
                return date.getTime();
            }
        }
        return DateFormatUtils.format((Date)date, (String)dateFormat.pattern(), (TimeZone)TimeZone.getTimeZone(dateFormat.timezone()));
    }
}

