/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.es.dal.genarate.req;

import co.elastic.clients.elasticsearch._types.query_dsl.BoolQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.es.dal.genarate.RequestGenerator;
import com.cyberway.mp.bc.es.dal.genarate.parser.AggregationsSource;
import com.cyberway.mp.bc.es.dal.genarate.parser.OrderBySource;
import com.cyberway.mp.bc.es.dal.genarate.parser.Predicate;
import java.lang.reflect.Method;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public abstract class BaseSearchRequestGenerator
extends RequestGenerator {
    protected <T> SearchRequest buildSearchRequest(Method method, Class<T> documentClass, Object[] args, Predicate predicate) {
        AggregationsSource aggregationsSource;
        SearchRequest.Builder searchReqBuilder = new SearchRequest.Builder();
        searchReqBuilder.index(this.getIndexName(documentClass), new String[0]);
        Query query = predicate.generate(method, args);
        String logicDeleteFieldName = this.getLogicDeleteField(documentClass);
        if (StringUtils.hasLength((String)logicDeleteFieldName)) {
            BoolQuery.Builder boolBuilder = new BoolQuery.Builder();
            boolBuilder.mustNot(TermQuery.of(termQueryBuilder -> termQueryBuilder.field(logicDeleteFieldName).value(true))._toQuery(), new Query[0]);
            boolBuilder.must(query, new Query[0]);
            searchReqBuilder.query(boolBuilder.build()._toQuery());
        } else {
            searchReqBuilder.query(query);
        }
        PageParam pageParam = this.getPageParamByDefault(args);
        searchReqBuilder.from(Integer.valueOf(pageParam.getOffset()));
        searchReqBuilder.size(Integer.valueOf(pageParam.getPageSize()));
        if (null != predicate.getOrderBySource() && OrderBySource.EMPTY != predicate.getOrderBySource()) {
            searchReqBuilder.sort(predicate.getOrderBySource().toSortOptions());
        }
        if (null != predicate.getHighlightSource()) {
            searchReqBuilder.highlight(predicate.getHighlightSource().toHighlight());
        }
        if (null != (aggregationsSource = this.getAggregationsSource(args)) && !CollectionUtils.isEmpty(aggregationsSource.getAggregationMap())) {
            searchReqBuilder.aggregations(aggregationsSource.getAggregationMap());
        }
        return searchReqBuilder.build();
    }
}

