/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.es.dal.genarate.req;

import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch.core.BulkRequest;
import co.elastic.clients.elasticsearch.core.bulk.IndexOperation;
import com.cyberway.mp.bc.es.dal.genarate.RequestGenerator;
import com.cyberway.mp.bc.es.dal.model.BaseDocument;
import java.lang.reflect.Method;
import java.util.Collection;
import org.apache.commons.lang3.ClassUtils;
import org.springframework.util.StringUtils;

public class BatchInsertRequestGenerator
extends RequestGenerator {
    public <T, PK> BulkRequest generate(Method method, Class<T> documentClass, Class<PK> primaryKeyClass, Object[] args) {
        BulkRequest.Builder builder = new BulkRequest.Builder();
        builder.index(this.getIndexName(documentClass));
        Collection<T> documentCollection = this.getNotEmptyInstanceCollection(documentClass, args);
        for (T document : documentCollection) {
            BaseDocument baseDocument;
            String id;
            IndexOperation.Builder indexOperationBuilder = new IndexOperation.Builder();
            indexOperationBuilder.document(document);
            if (document instanceof BaseDocument && StringUtils.hasLength((String)(id = this.convertId(primaryKeyClass, (baseDocument = (BaseDocument)document).getId())))) {
                indexOperationBuilder.id(id);
            }
            builder.refresh(Refresh.True);
            builder.operations(op -> op.index(indexOperationBuilder.build()));
        }
        return builder.build();
    }

    @Override
    public boolean match(Method method) {
        return null != method && "batchInsert".equals(method.getName()) && method.getParameterTypes().length == 1 && ClassUtils.isAssignable(method.getParameterTypes()[0], Collection.class);
    }
}

