/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.es.dal.genarate.req;

import co.elastic.clients.elasticsearch._types.FieldValue;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQuery;
import co.elastic.clients.elasticsearch._types.query_dsl.TermsQueryField;
import co.elastic.clients.elasticsearch.core.DeleteByQueryRequest;
import co.elastic.clients.elasticsearch.core.UpdateByQueryRequest;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import com.cyberway.mp.bc.es.dal.genarate.RequestGenerator;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ClassUtils;
import org.springframework.util.StringUtils;

public class DeleteByIdInRequestGenerator
extends RequestGenerator {
    @Override
    public <T, PK> RequestBase generate(Method method, Class<T> documentClass, Class<PK> primaryKeyClass, Object[] args) {
        String indexName = this.getIndexName(documentClass);
        String logicDeleteField = this.getLogicDeleteField(documentClass);
        Collection ids = this.getNotEmptyInstanceCollection(primaryKeyClass, args);
        TermsQuery idsQuery = TermsQuery.of(b -> b.field("id").terms(TermsQueryField.of(fieldBuilder -> fieldBuilder.value(ids.stream().map(id -> FieldValue.of((String)this.convertId(primaryKeyClass, id))).collect(Collectors.toList())))));
        if (StringUtils.hasLength((String)logicDeleteField)) {
            UpdateByQueryRequest.Builder updateByQueryReqBuilder = new UpdateByQueryRequest.Builder();
            updateByQueryReqBuilder.index(indexName, new String[0]);
            Script.Builder sb = new Script.Builder();
            String deleteStr = "ctx._source." + logicDeleteField;
            sb.inline(b -> (ObjectBuilder)b.source("if (" + deleteStr + " != true){ " + deleteStr + " = params['deleteValue']}").lang("painless").params(Collections.singletonMap("deleteValue", JsonData.of((Object)true))));
            updateByQueryReqBuilder.script(sb.build());
            updateByQueryReqBuilder.query(idsQuery._toQuery());
            updateByQueryReqBuilder.refresh(Boolean.valueOf(true));
            return updateByQueryReqBuilder.build();
        }
        DeleteByQueryRequest.Builder deleteReqBuilder = new DeleteByQueryRequest.Builder();
        deleteReqBuilder.index(this.getIndexName(documentClass), new String[0]);
        deleteReqBuilder.query(idsQuery._toQuery());
        deleteReqBuilder.refresh(Boolean.valueOf(true));
        return deleteReqBuilder.build();
    }

    @Override
    public boolean match(Method method) {
        return null != method && "deleteByIdIn".equals(method.getName()) && method.getParameterTypes().length == 1 && ClassUtils.isAssignable(method.getParameterTypes()[0], Collection.class);
    }
}

