/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.es.dal.genarate.req;

import co.elastic.clients.elasticsearch._types.Refresh;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch._types.Script;
import co.elastic.clients.elasticsearch._types.query_dsl.TermQuery;
import co.elastic.clients.elasticsearch.core.DeleteRequest;
import co.elastic.clients.elasticsearch.core.UpdateByQueryRequest;
import co.elastic.clients.json.JsonData;
import co.elastic.clients.util.ObjectBuilder;
import com.cyberway.mp.bc.es.dal.genarate.RequestGenerator;
import java.lang.reflect.Method;
import java.util.Collections;
import org.springframework.util.StringUtils;

public class DeleteRequestGenerator
extends RequestGenerator {
    @Override
    public <T, PK> RequestBase generate(Method method, Class<T> documentClass, Class<PK> primaryKeyClass, Object[] args) {
        String indexName = this.getIndexName(documentClass);
        String logicDeleteField = this.getLogicDeleteField(documentClass);
        if (StringUtils.hasLength((String)logicDeleteField)) {
            UpdateByQueryRequest.Builder updateByQueryReqBuilder = new UpdateByQueryRequest.Builder();
            updateByQueryReqBuilder.index(indexName, new String[0]);
            Script.Builder sb = new Script.Builder();
            String deleteStr = "ctx._source." + logicDeleteField;
            sb.inline(b -> (ObjectBuilder)b.source("if (" + deleteStr + " != true){ " + deleteStr + " = params['deleteValue']}").lang("painless").params(Collections.singletonMap("deleteValue", JsonData.of((Object)true))));
            updateByQueryReqBuilder.script(sb.build());
            TermQuery query = TermQuery.of(b -> b.field("id").value(this.convertId(primaryKeyClass, args[0])));
            updateByQueryReqBuilder.query(query._toQuery());
            updateByQueryReqBuilder.refresh(Boolean.valueOf(true));
            return updateByQueryReqBuilder.build();
        }
        DeleteRequest.Builder deleteReqBuilder = new DeleteRequest.Builder();
        deleteReqBuilder.index(indexName);
        deleteReqBuilder.id(this.convertId(primaryKeyClass, args[0]));
        deleteReqBuilder.refresh(Refresh.True);
        return deleteReqBuilder.build();
    }

    @Override
    public boolean match(Method method) {
        return null != method && "delete".equals(method.getName()) && method.getParameterTypes().length == 1;
    }
}

