/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.es.dal.genarate.resp;

import co.elastic.clients.elasticsearch.ElasticsearchClient;
import co.elastic.clients.elasticsearch._types.RequestBase;
import co.elastic.clients.elasticsearch.core.SearchRequest;
import co.elastic.clients.elasticsearch.core.SearchResponse;
import co.elastic.clients.elasticsearch.core.search.Hit;
import co.elastic.clients.elasticsearch.core.search.TotalHits;
import com.cyberway.mp.bc.common.api.Page;
import com.cyberway.mp.bc.common.api.PageParam;
import com.cyberway.mp.bc.es.dal.exception.ElasticSearchException;
import com.cyberway.mp.bc.es.dal.genarate.ResponseGenerator;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SearchResponseGenerator
implements ResponseGenerator {
    private static final Logger log = LoggerFactory.getLogger(SearchResponseGenerator.class);
    private final ElasticsearchClient elasticsearchClient;

    public SearchResponseGenerator(ElasticsearchClient elasticsearchClient) {
        this.elasticsearchClient = elasticsearchClient;
    }

    @Override
    public boolean match(RequestBase request) {
        return request instanceof SearchRequest;
    }

    @Override
    public <T, PK> Object generate(Method method, Class<T> documentClass, Class<PK> primaryKeyClass, Object[] args, RequestBase request) {
        Class<?> returnClass = method.getReturnType();
        if (returnClass.equals(Void.TYPE)) {
            return null;
        }
        try {
            SearchRequest searchRequest = (SearchRequest)request;
            if (returnClass.equals(SearchResponse.class)) {
                return this.elasticsearchClient.search(searchRequest, documentClass);
            }
            if (returnClass.equals(List.class)) {
                Class<?> actualClass = this.getReturnClassActualRawType(method);
                SearchResponse response = this.elasticsearchClient.search(searchRequest, actualClass);
                return response.hits().hits().stream().map(Hit::source).collect(Collectors.toList());
            }
            if (returnClass.equals(Page.class)) {
                Class<?> actualClass = this.getReturnClassActualRawType(method);
                SearchResponse response = this.elasticsearchClient.search(searchRequest, actualClass);
                PageParam pageParam = this.getPageParamByDefault(args);
                TotalHits total = response.hits().total();
                if (null == total || total.value() == 0L) {
                    return new Page(0, pageParam.getPageSize(), 0L, Collections.emptyList());
                }
                return new Page(pageParam.getCurrent(), pageParam.getPageSize(), total.value(), response.hits().hits().stream().map(Hit::source).collect(Collectors.toList()));
            }
            SearchResponse response = this.elasticsearchClient.search(searchRequest, returnClass);
            TotalHits total = response.hits().total();
            if (null == total || total.value() == 0L) {
                return null;
            }
            if (total.value() > 1L) {
                throw new IllegalCallerException("Expected one result (or null) to be returned by " + method.getName() + ", but found: " + total.value());
            }
            return ((Hit)response.hits().hits().get(0)).source();
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new ElasticSearchException("search\u64cd\u4f5c\u5f02\u5e38");
        }
    }

    public PageParam getPageParamByDefault(Object[] args) {
        if (null != args && args.length > 0) {
            for (Object arg : args) {
                if (!(arg instanceof PageParam)) continue;
                return (PageParam)arg;
            }
        }
        return new PageParam();
    }

    private Class<?> getReturnClassActualRawType(Method method) {
        Type genericReturnType = method.getGenericReturnType();
        if (genericReturnType instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)genericReturnType;
            return (Class)parameterizedType.getActualTypeArguments()[0];
        }
        return Map.class;
    }
}

