/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event;

import com.cyberway.mp.bc.event.BusinessEvent;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;
import java.util.Map;
import java.util.UUID;
import org.springframework.context.ApplicationEvent;

public class BaseBusinessEvent<T>
extends ApplicationEvent
implements BusinessEvent {
    private static final String EVENT_ID = "eventId";
    private static final String SEND_TIME = "sendTime";
    private static final String FINISH_TIME = "finishTime";
    private String eventId;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date sendTime;
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss", timezone="GMT+8")
    private Date finishTime;
    private T data;

    public BaseBusinessEvent(Object source, T data) {
        super(source);
        this.eventId = UUID.randomUUID().toString();
        this.data = data;
    }

    public BaseBusinessEvent(Object source, Map<String, Object> maps) {
        super(source);
        Long finishTimeLong;
        this.eventId = (String)maps.get(EVENT_ID);
        Long sendTimeLong = (Long)maps.get(SEND_TIME);
        if (sendTimeLong != null) {
            this.sendTime = new Date(sendTimeLong);
        }
        if ((finishTimeLong = (Long)maps.get(FINISH_TIME)) != null) {
            this.finishTime = new Date(finishTimeLong);
        }
    }

    @Override
    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    @Override
    public String getEventId() {
        return this.eventId;
    }

    @Override
    public void setSendTime(Date sendTime) {
        this.sendTime = sendTime;
    }

    @Override
    public Date getSendTime() {
        return this.sendTime;
    }

    @Override
    public void setFinishTime(Date finishTime) {
        this.finishTime = finishTime;
    }

    @Override
    public Date getFinishTime() {
        return this.finishTime;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }
}

