/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event;

import com.cyberway.mp.bc.event.BaseBusinessEvent;
import com.cyberway.mp.bc.event.FrameworkEventService;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class BusinessEventService
implements ApplicationContextAware {
    private ApplicationContext applicationContext;
    private final FrameworkEventService frameworkEventService;

    public BusinessEventService(FrameworkEventService frameworkEventService) {
        this.frameworkEventService = frameworkEventService;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void pushEvent(BaseBusinessEvent<?> event) {
        if (null != event) {
            switch (event.supportScope()) {
                case GLOBAL: {
                    this.applicationContext.publishEvent(event);
                    this.checkFrameworkEventService();
                    this.frameworkEventService.pushEvent(event);
                    break;
                }
                case MQ: {
                    this.checkFrameworkEventService();
                    this.frameworkEventService.pushEvent(event);
                    break;
                }
                case LOCAL: {
                    this.applicationContext.publishEvent(event);
                    break;
                }
            }
        }
    }

    private void checkFrameworkEventService() {
        if (null == this.frameworkEventService) {
            throw new UnsupportedOperationException("missing frameworkEventService");
        }
    }
}

