/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.anotation.kafka;

import com.cyberway.mp.bc.event.FrameworkEvent;
import com.cyberway.mp.bc.event.FrameworkEventConfigProperties;
import com.cyberway.mp.bc.event.anotation.FrameworkEventHandler;
import com.cyberway.mp.bc.event.anotation.FrameworkEventListener;
import com.cyberway.mp.bc.event.anotation.kafka.KafkaDeclareConfig;
import com.cyberway.mp.bc.event.anotation.kafka.KafkaTopicAutoDeclareListener;
import com.cyberway.mp.bc.event.service.kafka.KafkaTopicNameStrategy;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.lang3.StringUtils;
import org.apache.kafka.clients.admin.NewTopic;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.context.expression.StandardBeanExpressionResolver;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.MethodParameter;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.converter.Converter;
import org.springframework.format.support.DefaultFormattingConversionService;
import org.springframework.kafka.config.KafkaListenerEndpointRegistrar;
import org.springframework.kafka.config.KafkaListenerEndpointRegistry;
import org.springframework.kafka.config.MethodKafkaListenerEndpoint;
import org.springframework.kafka.core.KafkaAdmin;
import org.springframework.kafka.support.KafkaNull;
import org.springframework.messaging.Message;
import org.springframework.messaging.converter.GenericMessageConverter;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.HeaderMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.HeadersMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageMethodArgumentResolver;
import org.springframework.messaging.handler.annotation.support.PayloadMethodArgumentResolver;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.validation.Validator;

public class KafkaEventAnnotationBeanPostProcessor<K, V>
implements BeanPostProcessor,
Ordered,
BeanFactoryAware,
BeanClassLoaderAware,
SmartInitializingSingleton {
    private static final String GENERATED_ID_PREFIX = "com.cyberway.framework.event.FrameworkEventListenerEndpointContainer#";
    public static final String DEFAULT_FRAMEWORK_EVENT_LISTENER_CONTAINER_FACTORY_BEAN_NAME = "kafkaListenerContainerFactory";
    private final ListenerScope listenerScope = new ListenerScope();
    private final AtomicInteger counter = new AtomicInteger();
    private final KafkaListenerEndpointRegistrar registrar = new KafkaListenerEndpointRegistrar();
    private final FrameworkEventHandlerMethodFactoryAdapter messageHandlerMethodFactory = new FrameworkEventHandlerMethodFactoryAdapter();
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private String defaultContainerFactoryBeanName = "kafkaListenerContainerFactory";
    private ClassLoader classLoader;
    private BeanFactory beanFactory;
    private BeanExpressionResolver resolver = new StandardBeanExpressionResolver();
    private BeanExpressionContext expressionContext;
    private KafkaListenerEndpointRegistry endpointRegistry;
    private FrameworkEventConfigProperties frameworkEventConfigProperties;
    private Charset charset = StandardCharsets.UTF_8;
    private int increment = 0;

    public void setEndpointRegistry(KafkaListenerEndpointRegistry endpointRegistry) {
        this.endpointRegistry = endpointRegistry;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public void setFrameworkEventConfigProperties(FrameworkEventConfigProperties frameworkEventConfigProperties) {
        this.frameworkEventConfigProperties = frameworkEventConfigProperties;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableListableBeanFactory) {
            this.resolver = ((ConfigurableListableBeanFactory)beanFactory).getBeanExpressionResolver();
            this.expressionContext = new BeanExpressionContext((ConfigurableBeanFactory)((ConfigurableListableBeanFactory)beanFactory), (Scope)this.listenerScope);
        }
    }

    public void afterSingletonsInstantiated() {
        MessageHandlerMethodFactory handlerMethodFactory;
        this.registrar.setBeanFactory(this.beanFactory);
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (KafkaListenerEndpointRegistry)this.beanFactory.getBean("com.cyberway.framework.event.config.internalFrameworkEventListenerEndpointRegistry", KafkaListenerEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if (this.defaultContainerFactoryBeanName != null) {
            this.registrar.setContainerFactoryBeanName(this.defaultContainerFactoryBeanName);
        }
        if ((handlerMethodFactory = this.registrar.getMessageHandlerMethodFactory()) != null) {
            this.messageHandlerMethodFactory.setHandlerMethodFactory(handlerMethodFactory);
        }
        this.registrar.afterPropertiesSet();
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (!this.nonAnnotatedClasses.contains(bean.getClass())) {
            Class targetClass = AopUtils.getTargetClass((Object)bean);
            FrameworkEventListener classLevelListener = this.findListenerAnnotations(targetClass);
            boolean hasClassLevelListeners = classLevelListener != null;
            ArrayList<Method> multiMethods = new ArrayList<Method>();
            Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> {
                Set<FrameworkEventListener> listenerMethods = this.findListenerAnnotations(method);
                return !listenerMethods.isEmpty() ? listenerMethods : null;
            });
            if (hasClassLevelListeners) {
                Set methodsWithHandler = MethodIntrospector.selectMethods((Class)targetClass, method -> AnnotationUtils.findAnnotation((Method)method, FrameworkEventHandler.class) != null);
                multiMethods.addAll(methodsWithHandler);
            }
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(bean.getClass());
            } else {
                for (Map.Entry entry : annotatedMethods.entrySet()) {
                    Method method2 = (Method)entry.getKey();
                    for (FrameworkEventListener listener : (Collection)entry.getValue()) {
                        this.processFrameworkEventListener(listener, method2, bean, beanName);
                    }
                }
            }
            if (hasClassLevelListeners) {
                this.processMultiMethodListeners(classLevelListener, multiMethods, bean, beanName);
            }
        }
        return bean;
    }

    private Set<FrameworkEventListener> findListenerAnnotations(Method method) {
        HashSet<FrameworkEventListener> listeners = new HashSet<FrameworkEventListener>();
        FrameworkEventListener ann = (FrameworkEventListener)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)method, FrameworkEventListener.class);
        if (ann != null) {
            listeners.add(ann);
        }
        return listeners;
    }

    private void processMultiMethodListeners(FrameworkEventListener classLevelListener, List<Method> multiMethods, Object bean, String beanName) {
        ArrayList<Method> checkedMethods = new ArrayList<Method>();
        Method defaultMethod = null;
        for (Method method : multiMethods) {
            Method checked = this.checkProxy(method, bean);
            FrameworkEventHandler annotation = (FrameworkEventHandler)AnnotationUtils.findAnnotation((Method)method, FrameworkEventHandler.class);
            if (annotation != null && annotation.isDefault()) {
                Method toAssert = defaultMethod;
                Assert.state((toAssert == null ? 1 : 0) != 0, () -> "Only one @KafkaHandler can be marked 'isDefault', found: " + toAssert.toString() + " and " + method.toString());
                defaultMethod = checked;
            }
            checkedMethods.add(checked);
        }
        for (Method method : checkedMethods) {
            this.processFrameworkEventListener(classLevelListener, method, bean, beanName);
        }
    }

    protected void processFrameworkEventListener(FrameworkEventListener frameworkEventListener, Method method, Object bean, String beanName) {
        Method methodToUse = this.checkProxy(method, bean);
        MethodKafkaListenerEndpoint endpoint = new MethodKafkaListenerEndpoint();
        endpoint.setMethod(methodToUse);
        this.processListener(endpoint, frameworkEventListener, bean, methodToUse, beanName);
    }

    private Method checkProxy(Method methodArg, Object bean) {
        Method method = methodArg;
        if (AopUtils.isJdkDynamicProxy((Object)bean)) {
            try {
                Class[] proxiedInterfaces;
                method = bean.getClass().getMethod(method.getName(), method.getParameterTypes());
                for (Class iface : proxiedInterfaces = ((Advised)bean).getProxiedInterfaces()) {
                    try {
                        method = iface.getMethod(method.getName(), method.getParameterTypes());
                        break;
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                    }
                }
            }
            catch (SecurityException ex) {
                ReflectionUtils.handleReflectionException((Exception)ex);
            }
            catch (NoSuchMethodException ex) {
                throw new IllegalStateException(String.format("@FrameworkEventListener method '%s' found on bean target class '%s', but not found in any interface(s) for bean JDK proxy. Either pull the method up to an interface or switch to subclass (CGLIB) proxies by setting proxy-target-class/proxyTargetClass attribute to 'true'", method.getName(), method.getDeclaringClass().getSimpleName()), ex);
            }
        }
        return method;
    }

    protected void processListener(MethodKafkaListenerEndpoint<?, ?> endpoint, FrameworkEventListener frameworkEventListener, Object bean, Object adminTarget, String beanName) {
        endpoint.setBean(bean);
        endpoint.setMessageHandlerMethodFactory((MessageHandlerMethodFactory)this.messageHandlerMethodFactory);
        endpoint.setId(this.getEndpointId(frameworkEventListener));
        this.frameworkEventConfigProperties = (FrameworkEventConfigProperties)this.beanFactory.getBean(FrameworkEventConfigProperties.class);
        CharSequence[] topics = this.resolveTopics(frameworkEventListener);
        endpoint.setTopics((String[])topics);
        endpoint.setBeanFactory(this.beanFactory);
        endpoint.setGroupId(frameworkEventListener.queue());
        this.registrar.registerEndpoint(endpoint, null);
        if (Boolean.TRUE.equals(this.frameworkEventConfigProperties.getEnableAutoDeclare())) {
            KafkaDeclareConfig declareConfig = new KafkaDeclareConfig(frameworkEventListener);
            this.customDeclareConfig(declareConfig);
            NewTopic[] newTopicArr = new NewTopic[topics.length];
            for (int i = 0; i < topics.length; ++i) {
                String topic = topics[i];
                NewTopic newTopic = !CollectionUtils.isEmpty(declareConfig.getReplicasAssignments()) ? new NewTopic(topic, declareConfig.getReplicasAssignments()) : new NewTopic(topic, declareConfig.getNumPartitions().intValue(), declareConfig.getReplicationFactor().shortValue());
                newTopicArr[i] = newTopic;
            }
            KafkaAdmin.NewTopics newTopics = new KafkaAdmin.NewTopics(newTopicArr);
            ((ConfigurableBeanFactory)this.beanFactory).registerSingleton(String.join((CharSequence)"_", topics) + ++this.increment, (Object)newTopics);
        }
    }

    private void customDeclareConfig(KafkaDeclareConfig declareConfig) {
        Collection kafkaTopicAutoDeclareListeners = ((ListableBeanFactory)this.beanFactory).getBeansOfType(KafkaTopicAutoDeclareListener.class).values();
        for (KafkaTopicAutoDeclareListener kafkaTopicAutoDeclareListener : kafkaTopicAutoDeclareListeners) {
            kafkaTopicAutoDeclareListener.customConfigure(declareConfig);
        }
    }

    private String[] resolveTopics(FrameworkEventListener frameworkEventListener) {
        Class<? extends FrameworkEvent>[] events = frameworkEventListener.value();
        if (StringUtils.isBlank((CharSequence)this.frameworkEventConfigProperties.getKafka().getEventTopic())) {
            String[] topics = new String[events.length];
            for (int i = 0; i < events.length; ++i) {
                topics[i] = KafkaTopicNameStrategy.buildTopic(events[i], this.frameworkEventConfigProperties);
            }
            return topics;
        }
        return new String[]{this.frameworkEventConfigProperties.getKafka().getEventTopic()};
    }

    private String getEndpointId(FrameworkEventListener frameworkEventListener) {
        return GENERATED_ID_PREFIX + this.counter.getAndIncrement();
    }

    private FrameworkEventListener findListenerAnnotations(AnnotatedElement element) {
        return (FrameworkEventListener)AnnotationUtils.findAnnotation((AnnotatedElement)element, FrameworkEventListener.class);
    }

    private static class ListenerScope
    implements Scope {
        private final Map<String, Object> listeners = new HashMap<String, Object>();

        ListenerScope() {
        }

        public void addListener(String key, Object bean) {
            this.listeners.put(key, bean);
        }

        public void removeListener(String key) {
            this.listeners.remove(key);
        }

        public Object get(String name, ObjectFactory<?> objectFactory) {
            return this.listeners.get(name);
        }

        public Object remove(String name) {
            return null;
        }

        public void registerDestructionCallback(String name, Runnable callback) {
        }

        public Object resolveContextualObject(String key) {
            return this.listeners.get(key);
        }

        public String getConversationId() {
            return null;
        }
    }

    private class FrameworkEventHandlerMethodFactoryAdapter
    implements MessageHandlerMethodFactory {
        private MessageHandlerMethodFactory handlerMethodFactory;
        private final DefaultFormattingConversionService defaultFormattingConversionService = new DefaultFormattingConversionService();

        private FrameworkEventHandlerMethodFactoryAdapter() {
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            return this.getHandlerMethodFactory().createInvocableHandlerMethod(bean, method);
        }

        public MessageHandlerMethodFactory getHandlerMethodFactory() {
            if (this.handlerMethodFactory == null) {
                this.handlerMethodFactory = this.createDefaultMessageHandlerMethodFactory();
            }
            return this.handlerMethodFactory;
        }

        public void setHandlerMethodFactory(MessageHandlerMethodFactory handlerMethodFactory) {
            this.handlerMethodFactory = handlerMethodFactory;
        }

        private MessageHandlerMethodFactory createDefaultMessageHandlerMethodFactory() {
            DefaultMessageHandlerMethodFactory defaultFactory = new DefaultMessageHandlerMethodFactory();
            Validator validator = KafkaEventAnnotationBeanPostProcessor.this.registrar.getValidator();
            if (validator != null) {
                defaultFactory.setValidator(validator);
            }
            defaultFactory.setBeanFactory(KafkaEventAnnotationBeanPostProcessor.this.beanFactory);
            ConfigurableBeanFactory cbf = KafkaEventAnnotationBeanPostProcessor.this.beanFactory instanceof ConfigurableBeanFactory ? (ConfigurableBeanFactory)KafkaEventAnnotationBeanPostProcessor.this.beanFactory : null;
            this.defaultFormattingConversionService.addConverter((Converter)new BytesToStringConverter(KafkaEventAnnotationBeanPostProcessor.this.charset));
            defaultFactory.setConversionService((ConversionService)this.defaultFormattingConversionService);
            ArrayList<Object> argumentResolvers = new ArrayList<Object>();
            argumentResolvers.add(new HeaderMethodArgumentResolver((ConversionService)this.defaultFormattingConversionService, cbf));
            argumentResolvers.add(new HeadersMethodArgumentResolver());
            GenericMessageConverter messageConverter = new GenericMessageConverter((ConversionService)this.defaultFormattingConversionService);
            argumentResolvers.add(new MessageMethodArgumentResolver((MessageConverter)messageConverter));
            argumentResolvers.add((Object)new KafkaNullAwarePayloadArgumentResolver((MessageConverter)messageConverter, validator));
            defaultFactory.setArgumentResolvers(argumentResolvers);
            defaultFactory.afterPropertiesSet();
            return defaultFactory;
        }
    }

    private static class KafkaNullAwarePayloadArgumentResolver
    extends PayloadMethodArgumentResolver {
        KafkaNullAwarePayloadArgumentResolver(MessageConverter messageConverter, Validator validator) {
            super(messageConverter, validator);
        }

        public Object resolveArgument(MethodParameter parameter, Message<?> message) throws Exception {
            Object resolved = super.resolveArgument(parameter, message);
            if (resolved instanceof List) {
                List list = (List)resolved;
                for (int i = 0; i < list.size(); ++i) {
                    if (!(list.get(i) instanceof KafkaNull)) continue;
                    list.set(i, null);
                }
            }
            return resolved;
        }

        protected boolean isEmptyPayload(Object payload) {
            return payload == null || payload instanceof KafkaNull;
        }
    }

    private static class BytesToStringConverter
    implements Converter<byte[], String> {
        private final Charset charset;

        BytesToStringConverter(Charset charset) {
            this.charset = charset;
        }

        public String convert(byte[] source) {
            return new String(source, this.charset);
        }
    }
}

