/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.anotation.rocketmq;

import com.cyberway.mp.bc.event.FrameworkEvent;
import com.cyberway.mp.bc.event.FrameworkEventConfigProperties;
import com.cyberway.mp.bc.event.anotation.FrameworkEventHandler;
import com.cyberway.mp.bc.event.anotation.FrameworkEventListener;
import com.cyberway.mp.bc.event.anotation.rocketmq.ListenerWrap;
import com.cyberway.mp.bc.event.anotation.rocketmq.RocketMqAutoDeclareListener;
import com.cyberway.mp.bc.event.anotation.rocketmq.RocketMqDeclareConfig;
import com.cyberway.mp.bc.event.service.rocketmq.TopicTagNameStrategy;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.rocketmq.client.exception.MQClientException;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.messaging.converter.MessageConverter;
import org.springframework.util.ReflectionUtils;

public class RocketAnnotationProcessor {
    private final Logger logger = LoggerFactory.getLogger(RocketAnnotationProcessor.class);
    private final StandardEnvironment environment;
    private final MessageConverter messageConverter;
    private final FrameworkEventConfigProperties frameworkEventConfigProperties;
    private final DefaultMQProducer defaultMQProducer;

    public RocketAnnotationProcessor(StandardEnvironment environment, MessageConverter messageConverter, FrameworkEventConfigProperties frameworkEventConfigProperties, DefaultMQProducer defaultMQProducer) {
        this.environment = environment;
        this.messageConverter = messageConverter;
        this.frameworkEventConfigProperties = frameworkEventConfigProperties;
        this.defaultMQProducer = defaultMQProducer;
    }

    public ListenerWrap process(String beanName, Object bean, Collection<RocketMqAutoDeclareListener> rocketMqAutoDeclareListeners) {
        FrameworkEventListener frameworkEventListener = bean.getClass().getAnnotation(FrameworkEventListener.class);
        if (frameworkEventListener == null) {
            throw new IllegalArgumentException("\u4e8b\u4ef6\u5904\u7406\u9700\u8981\u4f7f\u7528@FrameworkEventListener");
        }
        if (frameworkEventListener.value().length > 1) {
            throw new IllegalArgumentException("\u4e8b\u4ef6\u5904\u7406rocketmq\u5b9e\u73b0\u652f\u6301\u4e00\u4e2alistener\u5904\u7406\u4e00\u4e2aevent");
        }
        Class<? extends FrameworkEvent> event = frameworkEventListener.value()[0];
        String topic = TopicTagNameStrategy.findTopicName(event, this.frameworkEventConfigProperties);
        String tag = TopicTagNameStrategy.findTag(frameworkEventListener);
        if (Boolean.TRUE.equals(this.frameworkEventConfigProperties.getEnableAutoDeclare())) {
            RocketMqDeclareConfig declareConfig = new RocketMqDeclareConfig(frameworkEventListener);
            if (null != rocketMqAutoDeclareListeners) {
                for (RocketMqAutoDeclareListener rocketMqAutoDeclareListener : rocketMqAutoDeclareListeners) {
                    rocketMqAutoDeclareListener.customConfigure(declareConfig);
                }
            }
            try {
                this.defaultMQProducer.createTopic("TBW102", topic, declareConfig.getQueueNum(), 0, new HashMap());
            }
            catch (MQClientException e) {
                this.logger.error("\u521b\u5efatopic\u5931\u8d25", (Throwable)e);
            }
        }
        return new ListenerWrap(this.messageConverter, this.findTargetMethod(bean), bean, frameworkEventListener.queue(), topic, tag, event);
    }

    private Method findTargetMethod(Object bean) {
        AtomicReference targetMethodRef = new AtomicReference();
        ReflectionUtils.doWithMethods(bean.getClass(), method -> {
            FrameworkEventHandler eventHandler = (FrameworkEventHandler)AnnotationUtils.findAnnotation((Method)method, FrameworkEventHandler.class);
            if (eventHandler != null) {
                targetMethodRef.set(method);
            }
        }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        return (Method)targetMethodRef.get();
    }
}

