/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.anotation.rocketmq;

import com.cyberway.mp.bc.common.api.exception.BaseException;
import com.cyberway.mp.bc.common.condition.ConditionalOnMutilPropertyValue;
import com.cyberway.mp.bc.event.FrameworkEventConfigProperties;
import com.cyberway.mp.bc.event.MiddlewareType;
import com.cyberway.mp.bc.event.anotation.FrameworkEventListener;
import com.cyberway.mp.bc.event.anotation.rocketmq.ListenerWrap;
import com.cyberway.mp.bc.event.anotation.rocketmq.RocketAnnotationProcessor;
import com.cyberway.mp.bc.event.anotation.rocketmq.RocketMqAutoDeclareListener;
import com.cyberway.mp.bc.event.service.rocketmq.EventRocketMQListenerContainer;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.rocketmq.client.AccessChannel;
import org.apache.rocketmq.client.producer.DefaultMQProducer;
import org.apache.rocketmq.spring.autoconfigure.RocketMQProperties;
import org.apache.rocketmq.spring.support.RocketMQMessageConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinitionCustomizer;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.StandardEnvironment;
import org.springframework.util.StringUtils;

@Configuration
@ConditionalOnMutilPropertyValue(name={"framework.event.type", "framework.event.types"}, havingValue={"rocketmq"})
public class RocketListenerContainerConfiguration
implements ApplicationContextAware,
SmartInitializingSingleton {
    private static final Logger LOGGER = LoggerFactory.getLogger(RocketListenerContainerConfiguration.class);
    private ConfigurableApplicationContext applicationContext;
    private final AtomicLong counter = new AtomicLong(0L);
    private final StandardEnvironment environment;
    private RocketMQProperties rocketMQProperties;
    private RocketMQMessageConverter rocketMQMessageConverter;
    private RocketAnnotationProcessor rocketAnnotationProcessor;
    private FrameworkEventConfigProperties frameworkEventConfigProperties;

    public RocketListenerContainerConfiguration(RocketMQMessageConverter rocketMQMessageConverter, StandardEnvironment environment, RocketMQProperties rocketMQProperties, FrameworkEventConfigProperties frameworkEventConfigProperties, @Qualifier(value="defaultMQProducer") DefaultMQProducer defaultMQProducer) {
        this.rocketMQMessageConverter = rocketMQMessageConverter;
        this.environment = environment;
        this.rocketMQProperties = rocketMQProperties;
        this.frameworkEventConfigProperties = frameworkEventConfigProperties;
        this.rocketAnnotationProcessor = new RocketAnnotationProcessor(environment, rocketMQMessageConverter.getMessageConverter(), frameworkEventConfigProperties, defaultMQProducer);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableApplicationContext)applicationContext;
    }

    public void afterSingletonsInstantiated() {
        Map<String, Object> beans = this.applicationContext.getBeansWithAnnotation(FrameworkEventListener.class).entrySet().stream().filter(entry -> {
            FrameworkEventListener listener = (FrameworkEventListener)AnnotationUtils.findAnnotation(entry.getValue().getClass(), FrameworkEventListener.class);
            boolean isFit = true;
            if (listener != null && !this.frameworkEventConfigProperties.getTypes().isEmpty()) {
                String type = listener.type();
                if (!MiddlewareType.ROCKETMQ.name().equalsIgnoreCase(type)) {
                    isFit = false;
                }
            }
            return !ScopedProxyUtils.isScopedTarget((String)((String)entry.getKey())) && isFit;
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        beans.forEach(this::registerContainer);
    }

    private void registerContainer(String beanName, Object bean) {
        ListenerWrap listenerWrap = this.rocketAnnotationProcessor.process(beanName, bean, this.applicationContext.getBeansOfType(RocketMqAutoDeclareListener.class).values());
        String consumerGroup = listenerWrap.getConsumerGroup();
        String topic = listenerWrap.getTopic();
        boolean listenerEnabled = this.rocketMQProperties.getConsumer().getListeners().getOrDefault(consumerGroup, Collections.emptyMap()).getOrDefault(topic, true);
        if (!listenerEnabled) {
            LOGGER.debug("Consumer Listener (group:{},topic:{}) is not enabled by configuration, will ignore initialization.", (Object)consumerGroup, (Object)topic);
            return;
        }
        String containerBeanName = String.format("%s_%s", EventRocketMQListenerContainer.class.getName(), this.counter.incrementAndGet());
        GenericApplicationContext genericApplicationContext = (GenericApplicationContext)this.applicationContext;
        genericApplicationContext.registerBean(containerBeanName, EventRocketMQListenerContainer.class, () -> this.createRocketMQListenerContainer(containerBeanName, bean, listenerWrap), new BeanDefinitionCustomizer[0]);
        EventRocketMQListenerContainer container = (EventRocketMQListenerContainer)genericApplicationContext.getBean(containerBeanName, EventRocketMQListenerContainer.class);
        if (!container.isRunning()) {
            try {
                container.start();
            }
            catch (Exception e) {
                throw new BaseException((Throwable)e);
            }
        }
        LOGGER.info("Register the listener to container, listenerBeanName:{}, containerBeanName:{}", (Object)beanName, (Object)containerBeanName);
    }

    private EventRocketMQListenerContainer createRocketMQListenerContainer(String name, Object bean, ListenerWrap listenerWrap) {
        EventRocketMQListenerContainer container = new EventRocketMQListenerContainer();
        container.setListenerWrap(listenerWrap);
        String nameServer = this.rocketMQProperties.getNameServer();
        container.setNameServer(nameServer);
        String accessChannel = this.rocketMQProperties.getAccessChannel();
        if (StringUtils.hasLength((String)accessChannel)) {
            container.setAccessChannel(AccessChannel.valueOf((String)accessChannel));
        }
        container.setTopic(this.environment.resolvePlaceholders(listenerWrap.getTopic()));
        String tags = this.environment.resolvePlaceholders(listenerWrap.getTag());
        if (StringUtils.hasLength((String)tags)) {
            container.setSelectorExpression(tags);
        }
        container.setConsumerGroup(this.environment.resolvePlaceholders(listenerWrap.getConsumerGroup()));
        container.setMessageConverter(this.rocketMQMessageConverter.getMessageConverter());
        container.setName(name);
        return container;
    }
}

