/*
 * Decompiled with CFR 0.152.
 */
package com.cyberway.mp.bc.event.anotation.servicebus;

import com.azure.core.http.rest.PagedIterable;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationClient;
import com.azure.messaging.servicebus.administration.ServiceBusAdministrationClientBuilder;
import com.azure.messaging.servicebus.administration.models.CreateRuleOptions;
import com.azure.messaging.servicebus.administration.models.QueueProperties;
import com.azure.messaging.servicebus.administration.models.RuleFilter;
import com.azure.messaging.servicebus.administration.models.RuleProperties;
import com.azure.messaging.servicebus.administration.models.SqlRuleFilter;
import com.azure.messaging.servicebus.administration.models.SubscriptionProperties;
import com.azure.messaging.servicebus.administration.models.TopicProperties;
import com.azure.spring.cloud.autoconfigure.jms.properties.AzureServiceBusJmsProperties;
import com.cyberway.mp.bc.event.FrameworkEventConfigProperties;
import com.cyberway.mp.bc.event.anotation.FrameworkEventHandler;
import com.cyberway.mp.bc.event.anotation.FrameworkEventListener;
import com.cyberway.mp.bc.event.anotation.servicebus.ServiceBusQueueAutoDeclareListener;
import com.cyberway.mp.bc.event.anotation.servicebus.ServiceBusQueueDeclareConfig;
import com.cyberway.mp.bc.event.anotation.servicebus.ServiceBusTopicSubscriptionAutoDeclareListener;
import com.cyberway.mp.bc.event.anotation.servicebus.ServiceBusTopicSubscriptionDeclareConfig;
import com.cyberway.mp.bc.event.service.servicebus.ServiceBusDestinationStrategy;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.aop.framework.AopInfrastructureBean;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.EmbeddedValueResolver;
import org.springframework.beans.factory.support.MergedBeanDefinitionPostProcessor;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.MethodIntrospector;
import org.springframework.core.Ordered;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.jms.annotation.JmsListenerConfigurer;
import org.springframework.jms.config.JmsListenerContainerFactory;
import org.springframework.jms.config.JmsListenerEndpoint;
import org.springframework.jms.config.JmsListenerEndpointRegistrar;
import org.springframework.jms.config.JmsListenerEndpointRegistry;
import org.springframework.jms.config.MethodJmsListenerEndpoint;
import org.springframework.lang.Nullable;
import org.springframework.messaging.handler.annotation.support.DefaultMessageHandlerMethodFactory;
import org.springframework.messaging.handler.annotation.support.MessageHandlerMethodFactory;
import org.springframework.messaging.handler.invocation.InvocableHandlerMethod;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.util.StringValueResolver;

public class ServiceBusListenerAnnotationBeanPostProcessor
implements MergedBeanDefinitionPostProcessor,
Ordered,
BeanFactoryAware,
SmartInitializingSingleton {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final FrameworkEventConfigProperties frameworkEventConfigProperties;
    private final AzureServiceBusJmsProperties azureServiceBusJmsProperties;
    private BeanFactory beanFactory;
    private StringValueResolver embeddedValueResolver;
    private JmsListenerEndpointRegistry endpointRegistry;
    private final AtomicInteger counter = new AtomicInteger();
    private final MessageHandlerMethodFactoryAdapter messageHandlerMethodFactory = new MessageHandlerMethodFactoryAdapter();
    private final Set<Class<?>> nonAnnotatedClasses = Collections.newSetFromMap(new ConcurrentHashMap(64));
    private final JmsListenerEndpointRegistrar registrar = new JmsListenerEndpointRegistrar();
    private final Map<String, Set<String>> alreadyExistedTopicSubscription = new ConcurrentHashMap<String, Set<String>>(64);
    private final Map<TopicProperties, Set<SubscriptionProperties>> alreadyExistedTopicSubscriptionProperties = new ConcurrentHashMap<TopicProperties, Set<SubscriptionProperties>>(64);
    private final Map<String, QueueProperties> alreadyExistedQueue = new ConcurrentHashMap<String, QueueProperties>(64);
    private final AtomicBoolean initCache = new AtomicBoolean(false);
    private final ServiceBusAdministrationClient administrationClient;

    public ServiceBusListenerAnnotationBeanPostProcessor(FrameworkEventConfigProperties frameworkEventConfigProperties, AzureServiceBusJmsProperties azureServiceBusJmsProperties) {
        this.frameworkEventConfigProperties = frameworkEventConfigProperties;
        this.azureServiceBusJmsProperties = azureServiceBusJmsProperties;
        this.administrationClient = new ServiceBusAdministrationClientBuilder().connectionString(azureServiceBusJmsProperties.getConnectionString()).buildClient();
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
        if (beanFactory instanceof ConfigurableBeanFactory) {
            this.embeddedValueResolver = new EmbeddedValueResolver((ConfigurableBeanFactory)beanFactory);
        }
        this.registrar.setBeanFactory(beanFactory);
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof AopInfrastructureBean || bean instanceof JmsListenerContainerFactory || bean instanceof JmsListenerEndpointRegistry) {
            return bean;
        }
        Class targetClass = AopProxyUtils.ultimateTargetClass((Object)bean);
        if (!this.nonAnnotatedClasses.contains(targetClass) && AnnotationUtils.isCandidateClass((Class)targetClass, FrameworkEventListener.class)) {
            FrameworkEventListener frameworkEventListener = (FrameworkEventListener)AnnotationUtils.getAnnotation((AnnotatedElement)targetClass, FrameworkEventListener.class);
            Map annotatedMethods = MethodIntrospector.selectMethods((Class)targetClass, method -> (FrameworkEventHandler)AnnotatedElementUtils.getMergedAnnotation((AnnotatedElement)method, FrameworkEventHandler.class));
            if (annotatedMethods.isEmpty()) {
                this.nonAnnotatedClasses.add(targetClass);
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("No @FrameworkEventHandler annotations found on bean type: {}", (Object)targetClass);
                }
            } else {
                if (annotatedMethods.size() > 1) {
                    throw new IllegalArgumentException("find more than one @FrameworkEventHandler annotation on method for class: " + targetClass);
                }
                if (null == frameworkEventListener) {
                    throw new IllegalArgumentException("no @FrameworkEventListener annotation on class " + targetClass);
                }
                annotatedMethods.forEach((method, eventHandler) -> this.processListener(frameworkEventListener, (FrameworkEventHandler)eventHandler, (Method)method, bean));
            }
        }
        return bean;
    }

    protected void processListener(FrameworkEventListener frameworkEventListener, FrameworkEventHandler frameworkEventHandler, Method mostSpecificMethod, Object bean) {
        Method invocableMethod = AopUtils.selectInvocableMethod((Method)mostSpecificMethod, bean.getClass());
        MethodJmsListenerEndpoint endpoint = new MethodJmsListenerEndpoint();
        endpoint.setBean(bean);
        endpoint.setMethod(invocableMethod);
        endpoint.setMostSpecificMethod(mostSpecificMethod);
        endpoint.setMessageHandlerMethodFactory((MessageHandlerMethodFactory)this.messageHandlerMethodFactory);
        endpoint.setEmbeddedValueResolver(this.embeddedValueResolver);
        endpoint.setBeanFactory(this.beanFactory);
        endpoint.setId(this.getEndpointId());
        String topicOrQueueName = this.resolve(ServiceBusDestinationStrategy.findTopicOrQueueName(frameworkEventListener.value()[0], this.frameworkEventConfigProperties));
        endpoint.setDestination(topicOrQueueName);
        String subscriptionName = null;
        String route = null;
        if (StringUtils.hasText((String)frameworkEventListener.queue())) {
            subscriptionName = this.resolve(frameworkEventListener.queue());
            endpoint.setSubscription(subscriptionName);
        }
        if (StringUtils.hasText((String)frameworkEventListener.route())) {
            if (Boolean.TRUE.equals(this.frameworkEventConfigProperties.getServiceBus().getEnableRouteFilter())) {
                route = this.resolve(frameworkEventListener.route());
            } else {
                subscriptionName = this.resolve(frameworkEventListener.route());
                endpoint.setSubscription(subscriptionName);
            }
        }
        JmsListenerContainerFactory factory = null;
        String containerFactoryBeanName = this.resolve(frameworkEventListener.containerFactory());
        if (!StringUtils.hasText((String)containerFactoryBeanName) && StringUtils.hasText((String)frameworkEventListener.queue())) {
            containerFactoryBeanName = "topicJmsListenerContainerFactory";
        }
        if (StringUtils.hasText((String)containerFactoryBeanName)) {
            Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to obtain container factory by bean name");
            try {
                factory = (JmsListenerContainerFactory)this.beanFactory.getBean(containerFactoryBeanName, JmsListenerContainerFactory.class);
            }
            catch (NoSuchBeanDefinitionException ex) {
                throw new BeanInitializationException("Could not register FrameworkEventListener endpoint on [" + mostSpecificMethod + "], no " + JmsListenerContainerFactory.class.getSimpleName() + " with id '" + containerFactoryBeanName + "' was found in the application context", (Throwable)ex);
            }
        }
        if (Boolean.TRUE.equals(this.frameworkEventConfigProperties.getEnableAutoDeclare())) {
            this.autoDeclare(frameworkEventListener, topicOrQueueName, subscriptionName, route);
        }
        this.registrar.registerEndpoint((JmsListenerEndpoint)endpoint, factory);
    }

    private void autoDeclare(FrameworkEventListener frameworkEventListener, String topicOrQueueName, String subscriptionName, String route) {
        this.checkCache();
        if (StringUtils.hasText((String)subscriptionName)) {
            ServiceBusTopicSubscriptionDeclareConfig declareConfig = new ServiceBusTopicSubscriptionDeclareConfig(frameworkEventListener);
            Collection listeners = ((ListableBeanFactory)this.beanFactory).getBeansOfType(ServiceBusTopicSubscriptionAutoDeclareListener.class).values();
            for (ServiceBusTopicSubscriptionAutoDeclareListener listener : listeners) {
                listener.customConfigure(declareConfig);
            }
            this.createOrUpdateTopicSubscription(topicOrQueueName, subscriptionName, declareConfig.isUpdateIfExisted(), declareConfig.getTopicConfig(), declareConfig.getSubscriptionConfig());
            this.createOrUpdateRouteRule(topicOrQueueName, subscriptionName, route);
        } else {
            ServiceBusQueueDeclareConfig declareConfig = new ServiceBusQueueDeclareConfig(frameworkEventListener);
            Collection listeners = ((ListableBeanFactory)this.beanFactory).getBeansOfType(ServiceBusQueueAutoDeclareListener.class).values();
            for (ServiceBusQueueAutoDeclareListener listener : listeners) {
                listener.customConfigure(declareConfig);
            }
            this.createOrUpdateQueue(topicOrQueueName, declareConfig.isUpdateIfExisted(), declareConfig.getQueueConfig());
        }
    }

    private void createOrUpdateQueue(String queueName, boolean updateIfExisted, ServiceBusQueueDeclareConfig.QueueConfig queueConfig) {
        if (this.alreadyExistedQueue.containsKey(queueName = queueName.toLowerCase())) {
            if (updateIfExisted) {
                QueueProperties queueProperties = this.alreadyExistedQueue.get(queueName);
                queueConfig.updateQueueProperties(queueProperties);
                this.administrationClient.updateQueue(queueProperties);
            }
        } else {
            QueueProperties queueProperties = this.administrationClient.createQueue(queueName, queueConfig.toCreateQueueOptions());
            this.alreadyExistedQueue.put(queueName, queueProperties);
        }
    }

    private void createOrUpdateTopicSubscription(String topicName, String subscriptionName, boolean updateIfExisted, ServiceBusTopicSubscriptionDeclareConfig.TopicConfig topicConfig, ServiceBusTopicSubscriptionDeclareConfig.SubscriptionConfig subscriptionConfig) {
        String lowerCaseTopicName = topicName.toLowerCase();
        if (this.alreadyExistedTopicSubscription.containsKey(lowerCaseTopicName)) {
            String existedSubscriptionName;
            TopicProperties topicProperties = this.alreadyExistedTopicSubscriptionProperties.keySet().stream().filter(t -> t.getName().equalsIgnoreCase(lowerCaseTopicName)).findFirst().orElse(null);
            if (updateIfExisted && null != topicProperties) {
                topicConfig.updateTopicProperties(topicProperties);
                this.administrationClient.updateTopic(topicProperties);
            }
            if (StringUtils.hasText((String)(existedSubscriptionName = (String)this.alreadyExistedTopicSubscription.get(lowerCaseTopicName).stream().filter(s -> s.equalsIgnoreCase(subscriptionName)).findFirst().orElse(null)))) {
                SubscriptionProperties subscriptionProperties;
                if (updateIfExisted && null != (subscriptionProperties = (SubscriptionProperties)this.alreadyExistedTopicSubscriptionProperties.get(topicProperties).stream().filter(s -> s.getSubscriptionName().equalsIgnoreCase(subscriptionName)).findFirst().orElse(null))) {
                    subscriptionConfig.updateSubscriptionProperties(subscriptionProperties);
                    this.administrationClient.updateSubscription(subscriptionProperties);
                }
            } else {
                SubscriptionProperties subscriptionProperties = this.administrationClient.createSubscription(lowerCaseTopicName, subscriptionName, subscriptionConfig.toCreateSubscriptionOptions());
                this.alreadyExistedTopicSubscription.get(lowerCaseTopicName).add(subscriptionName);
                this.alreadyExistedTopicSubscriptionProperties.get(topicProperties).add(subscriptionProperties);
            }
        } else {
            TopicProperties topicProperties = this.administrationClient.createTopic(lowerCaseTopicName, topicConfig.toCreateTopicOptions());
            SubscriptionProperties subscriptionProperties = this.administrationClient.createSubscription(lowerCaseTopicName, subscriptionName, subscriptionConfig.toCreateSubscriptionOptions());
            HashSet<String> subscriptionNames = new HashSet<String>(16);
            subscriptionNames.add(subscriptionName);
            HashSet<SubscriptionProperties> subscriptions = new HashSet<SubscriptionProperties>(16);
            subscriptions.add(subscriptionProperties);
            this.alreadyExistedTopicSubscription.put(lowerCaseTopicName, subscriptionNames);
            this.alreadyExistedTopicSubscriptionProperties.put(topicProperties, subscriptions);
        }
    }

    private void createOrUpdateRouteRule(String topicName, String subscriptionName, String route) {
        if (!StringUtils.hasText((String)route)) {
            return;
        }
        if (Boolean.TRUE.equals(this.frameworkEventConfigProperties.getServiceBus().getEnableRouteFilter())) {
            RuleProperties targetRouteRule = null;
            PagedIterable ruleProperties = this.administrationClient.listRules(topicName, subscriptionName);
            for (RuleProperties ruleProperty : ruleProperties) {
                if ("$Default".equals(ruleProperty.getName())) {
                    this.administrationClient.deleteRule(topicName, subscriptionName, "$Default");
                    continue;
                }
                if (!"cbyMpServiceBusRouteRule".equals(ruleProperty.getName())) continue;
                targetRouteRule = ruleProperty;
            }
            String filterExpression = String.format("%s='%s'", "cby_mp_service_bus_route_key", route);
            SqlRuleFilter sqlRuleFilter = new SqlRuleFilter(filterExpression);
            if (null != targetRouteRule) {
                targetRouteRule.setFilter((RuleFilter)sqlRuleFilter);
                this.administrationClient.updateRule(topicName, subscriptionName, targetRouteRule);
            } else {
                this.administrationClient.createRule(topicName, "cbyMpServiceBusRouteRule", subscriptionName, new CreateRuleOptions((RuleFilter)sqlRuleFilter));
            }
        }
    }

    private void checkCache() {
        if (!this.initCache.get()) {
            this.administrationClient.listTopics().stream().forEach(topicProperties -> {
                String topicName = topicProperties.getName().toLowerCase();
                HashSet subscriptions = new HashSet(16);
                HashSet subscriptionProperties = new HashSet(16);
                this.alreadyExistedTopicSubscription.put(topicName, subscriptions);
                this.alreadyExistedTopicSubscriptionProperties.put((TopicProperties)topicProperties, subscriptionProperties);
                this.administrationClient.listSubscriptions(topicName).stream().forEach(subscription -> {
                    subscriptions.add(subscription.getSubscriptionName().toLowerCase());
                    subscriptionProperties.add(subscription);
                });
            });
            this.administrationClient.listQueues().stream().forEach(queue -> this.alreadyExistedQueue.put(queue.getName().toLowerCase(), (QueueProperties)queue));
            this.initCache.set(true);
        }
    }

    private String getEndpointId() {
        return "com.cyberway.mp.bc.event.ServiceBusListenerEndpointContainer#" + this.counter.getAndIncrement();
    }

    private String resolve(String value) {
        return this.embeddedValueResolver != null ? this.embeddedValueResolver.resolveStringValue(value) : value;
    }

    public void afterSingletonsInstantiated() {
        MessageHandlerMethodFactory handlerMethodFactory;
        this.nonAnnotatedClasses.clear();
        this.alreadyExistedTopicSubscription.clear();
        this.alreadyExistedTopicSubscriptionProperties.clear();
        this.alreadyExistedQueue.clear();
        if (this.beanFactory instanceof ListableBeanFactory) {
            Map beans = ((ListableBeanFactory)this.beanFactory).getBeansOfType(JmsListenerConfigurer.class);
            ArrayList configurers = new ArrayList(beans.values());
            AnnotationAwareOrderComparator.sort(configurers);
            for (JmsListenerConfigurer configurer : configurers) {
                configurer.configureJmsListeners(this.registrar);
            }
        }
        this.registrar.setContainerFactoryBeanName("jmsListenerContainerFactory");
        if (this.registrar.getEndpointRegistry() == null) {
            if (this.endpointRegistry == null) {
                Assert.state((this.beanFactory != null ? 1 : 0) != 0, (String)"BeanFactory must be set to find endpoint registry by bean name");
                this.endpointRegistry = (JmsListenerEndpointRegistry)this.beanFactory.getBean("org.springframework.jms.config.internalJmsListenerEndpointRegistry", JmsListenerEndpointRegistry.class);
            }
            this.registrar.setEndpointRegistry(this.endpointRegistry);
        }
        if ((handlerMethodFactory = this.registrar.getMessageHandlerMethodFactory()) != null) {
            this.messageHandlerMethodFactory.setMessageHandlerMethodFactory(handlerMethodFactory);
        }
        this.registrar.afterPropertiesSet();
    }

    public void postProcessMergedBeanDefinition(RootBeanDefinition rootBeanDefinition, Class<?> aClass, String s) {
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    private class MessageHandlerMethodFactoryAdapter
    implements MessageHandlerMethodFactory {
        @Nullable
        private MessageHandlerMethodFactory messageHandlerMethodFactory;

        private MessageHandlerMethodFactoryAdapter() {
        }

        public void setMessageHandlerMethodFactory(MessageHandlerMethodFactory messageHandlerMethodFactory) {
            this.messageHandlerMethodFactory = messageHandlerMethodFactory;
        }

        public InvocableHandlerMethod createInvocableHandlerMethod(Object bean, Method method) {
            return this.getMessageHandlerMethodFactory().createInvocableHandlerMethod(bean, method);
        }

        private MessageHandlerMethodFactory getMessageHandlerMethodFactory() {
            if (this.messageHandlerMethodFactory == null) {
                this.messageHandlerMethodFactory = this.createDefaultJmsHandlerMethodFactory();
            }
            return this.messageHandlerMethodFactory;
        }

        private MessageHandlerMethodFactory createDefaultJmsHandlerMethodFactory() {
            DefaultMessageHandlerMethodFactory defaultFactory = new DefaultMessageHandlerMethodFactory();
            if (ServiceBusListenerAnnotationBeanPostProcessor.this.beanFactory != null) {
                defaultFactory.setBeanFactory(ServiceBusListenerAnnotationBeanPostProcessor.this.beanFactory);
            }
            defaultFactory.afterPropertiesSet();
            return defaultFactory;
        }
    }
}

